//HEADER FILES
#include "mbed.h"
#include "C12832.h"
#include "MMA7660.h"
#include <time.h>
#include <stdlib.h>

//IMPORTANT INITIALIZATIONS
Serial pc(USBTX, USBRX); 
C12832 lcd(p5, p7, p6, p8, p11);
BusIn joy(p15,p12,p13,p16);
DigitalIn fire(p14);
BusOut leds(LED1,LED2,LED3,LED4);
MMA7660 MMA(p28, p27); //I2C Accelerometer
DigitalOut connectionLed(LED1);//Accel OK LED


int main()
{
    //IMPORTANT VARIABLE DECLARATIONS
    srand(time(NULL));
    int r = rand();
    int i=0;
    int dimX = 120;
    int dimY = 28;
    int x=0,y=0;
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("welcome to 3D snake game");
    wait(2);
    lcd.cls();
    lcd.locate(0, 3);
    lcd.printf("hit joystick 4 fireball");
    wait(1.5); 
    int j = 0;
    int cst = 4;
    int fDimX = dimX - cst;
    int fDimY = dimY - cst;
    int flag = 0;
    int p1 = r % fDimX;
    int p2 = r % fDimY;
    int score = 0;
    int bonus = 0;
    if (p1 < 10)
        p1 = 10;
    if (p2 < 10)
        p2 = 10;
    while(1) {
        //CONDITION FOR CHECKING FOR THE FIREBALL
        if (fire && score>5) {
            leds=0xf;
            flag = 100;
            if(bonus == 0){
                score -= 2;
                bonus = 1;
                }
        } 
        // CONDITIONS TO CHECK FOR JOYSTICK INPUT
        else {
            if (flag == 0){
            leds=joy;
            // moving the snake backwards
            if (joy == 0x4 ){
                i= i - cst;
                if (i < 0)
                    i = dimX;
                    }
            // moving the snake forward        
            else if (joy == 0x8){
                i = (i + cst)%dimX;
                }
            // moving the snake up    
            else if (joy == 0x1){
                j = j - cst;
                if (j < 0)
                    j = dimY;
                    }
            // moving the snake down        
            else if (joy == 0x2){
                j = (j + cst)%dimY;
                }
            }
        // LOGIC FOR THE FIREBALL         
        if (flag >= 1){
        x = (x + MMA.x() * 32.0)/1.5;
        y = (y -(MMA.y() * 16.0))/1.5;
        lcd.fillcircle(x+63, y+15, 3, 1); //draw bubble
        //lcd.circle(63, 15, 8, 1);
        wait(.1); //time delay
        pc.printf(" score %d", score);
        flag -=1;
        if (abs(x + 63 - p1) <=cst && abs(y + 15 - p2) <=cst+1){
            score +=15;
            flag = -1;
        }
        if (flag < 0)
            flag = 0;
            bonus = 0; 
        lcd.fillcircle(x+63, y+15, 3, 0); //erase bubble
        }            
        }
        if (flag == 0){
        //printing the snake, food and score on the LCD
        lcd.cls();      
        lcd.locate(i,j);
        lcd.printf("~+");
        lcd.locate(0, 22);
        lcd.printf("%d", score);
        //pc.printf("the dot is at %d %d\n \r", p1, p2); 
        pc.printf("snake location %d %d\n \r", i, j);
        lcd.locate(p1, p2);
        lcd.printf(".");
        // CONDITION FOR CHECKING THE SNAKE FOOD COLLISION
        if (abs(i + 8 - p1) <=cst && abs(j - p2) <=cst+1){ 
            //pc.printf("the snake is at %d %d\n \r", i, j);
            //pc.printf("the dot is at %d %d\n \r", p1, p2);
            score = score + 1; 
            //finding a new random location for food
            r = rand();
            p1 = r%fDimX;
            p2 = r%fDimY;
            //boundary checking
            if (p1 < 10)
                p1 = 10;
            if (p2 < 10)
                p2 = 10;
            lcd.printf(".");
            }
        wait(0.3);
        }
    }
}