/* mbed Newhaven LCD simple Pong demonstration
 * Copywrite (c) 2011, Paul Evans
 */

#include "mbed.h"
#include "newhaven.h"

BusInOut  MyBus(p8,p9,p10,p11,p12,p13,p14,p15);
NHLCD   MyLCD(p5,p6,p7,p16,p17,&MyBus);

int main() {
    int r1 = 100, r2 = 100, rb = 115, cb = 155;
    int dr = 5, dc = 5;

    MyLCD.Init();
    MyLCD.clearScreen();
    wait(.5);
    MyLCD.text("PONG!", 0, 15);
        
    while(1)
    {
        MyLCD.fillRect(r1, 0, 20, 4, 1);    // draw the paddles and ball
        MyLCD.fillRect(r2, 312, 20, 4, 1);
        MyLCD.fillRect(rb, cb, 3, 3, 1);
        
        wait(.2);                           // wait between frames                            
        
        MyLCD.fillRect(r1, 0, 20, 4, 0);    // clear the paddles and balls
        MyLCD.fillRect(r2, 312, 20, 4, 0);
        MyLCD.fillRect(rb, cb, 4, 4, 0);
        
        rb += dr;   // move the ball
        cb += dc;
        if (cb > 100) { // move the right paddle if necessary
            if (r2 > rb && r2 > 0) r2-=5;
            else if (r2 < 214) r2+=5;
        }
        if (cb < 220) { // move the left paddle if necessary
            if (r1 > rb && r1 > 0) r1-=5;
            else if (r1 < 214) r1+=5;
        }
        if (cb > 310 || cb < 4){    // check bounds for ball column
            dc = -dc;
            cb += dc;
        }if (rb < 10 || rb > 234){  // check bounds for ball row
            dr = -dr;
            rb += dr;
        }
    }
}
