#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"

EthernetNetIf eth;

HTTPServer svr;

LocalFileSystem fs("webfs");

//Create a function of the required format
void testFunc(char * input, char * output);
//Attach it to an RPC object
RPCFunction rpcTestFunc(&testFunc, "testFunc");

int main() {

    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<AnalogIn>();


    printf("Setting up...\r\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\r\n", ethErr);
        return -1;
    }
    printf("Setup OK\r\n");

    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    svr.addHandler<SimpleHandler>("/hello"); //Default handler
    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/"); //Default handler

    svr.bind(80);

    printf("Listening...\r\n");

    Timer tm;
    tm.start();
    //Listen indefinitely
    while (true) {
        Net::poll();
        if (tm.read()>.5) {
            tm.start();
            printf("alive!\r\n");
        }
    }

    return 0;
}

void testFunc(char * input, char * output) {

    static int toggle=0;

    if (toggle != 0) {
        sprintf(output, "Hello");
        toggle = 0;
    } else {
        sprintf(output, "Bye !");
        toggle = 1;
    }
}

