/*inbuilt native libraries*/
#include "mbed.h"
#include "tsi_sensor.h"
#include"beep.h"          

#if defined (TARGET_KL25Z)
#define ELEC0 9 //Electrode 0 of touch slider at pin 9
#define ELEC1 10 //Electrode 1 of touch slider at pin 10
#else
#error TARGET NOT DEFINED
#endif



/*predefined equivalent morse codes for each alphabet
1 represents dot
2 represents dash*/

int morse[26] = {21,1112,1212,112,1,1211,122,1111,11,2221,
                212,1121,22,12,222,1221,2122,121,111,2,
                211,2111,221,2112,2212,1122};

float slider = -1.0; 
DigitalOut buzzer(PTB0); //Object buzzer of class Beep
Serial pc(USBTX,USBRX); //Creating object of class Serial


int main(){
    int alpha_input;
    int temp,c,t;
    TSIAnalogSlider tsi(ELEC0, ELEC1, 80);
    pc.printf("\nPlease enter the letter to hear its corresponding Morse Code or Touch the slider\n");
    
    while(1){
       
       if(pc.readable())
       {
            alpha_input = pc.getc();
            pc.printf("\n%c",alpha_input);
            pc.printf("\nASCII Equivalent for letter entered: %d  \n",(int)alpha_input);
            
            /*To map lower case characters*/
            if(alpha_input<123 && alpha_input>96)
                alpha_input=alpha_input - 97; 
           
            /*To map upper case characters*/
            else if(alpha_input<91 &&alpha_input>64)
                alpha_input=alpha_input-65;
           
            else
                pc.printf("\nInvalid character entered. \n");
                
            c=alpha_input;
                
            if(c>=0 && c<26)
                {
                    temp = morse[c];
                    
                    /*Generate morse code*/
                    while(temp!=0)
                       {
                        t=temp%10;
                        temp=temp/10;
                        if(t==1){
                            buzzer=1;
                            wait(0.1);
                            buzzer=0;
                            pc.printf(".");
                            }
                            
                        else if(t==2){
                            buzzer=1;
                            wait(0.25);
                            buzzer=0;
                            pc.printf("-");
                            }
                            wait(0.2);
                        }
                    }
           wait(0.5);
           pc.printf("\n");
           }
           
           if(tsi.readPercentage() != 0) {   
            slider = tsi.readPercentage(); 
                //set slidervalue ( / divisor )
        
        
           if(slider>0 && slider<0.5)
                    {
                            buzzer=1;
                            wait(0.1);
                            buzzer=0;
                            pc.printf(".");
                    }
           if(slider>0.5 && slider<0.98){
                            buzzer=1;
                            wait(0.25);
                            buzzer=0;
                            pc.printf("-");
            }    
            }
 }   
}