// 1er test du MAX7301 : 8 sorties leds (bargraph) sur P19..P12 
// (Anodes tirées au VDD via 8xR-220)
 
#include "mbed.h"
/* Configuration du bus SPI */
DigitalOut cs_spi(D10); 
//SPI my_spi(SPI_MOSI, NC, SPI_SCK);
SPI my_spi(D11, NC, D13); // The default settings of the SPI interface 
                          // are 1MHz, 8-bit, Mode 0.

// Déclaration des fonctions
void write_max7301(char , char); 

int main() 
{
    write_max7301(0x09 , 0x55); // Voir préconisation datasheet page 5 :
    write_max7301(0x0A , 0x55); // ecrire 0x55 dans les 2 registres de 
                                // configuration des ports P4 à P11 qui 
                                // n'existe pas sur la version 28pins...
                                // Cela configure les 8 ports en sorties (virtuelles) 
                                
    write_max7301(0x04 , 0x01); // Ecriture de 0X01 dans le registre 
                                // "configuration" pour passer en mode "normal operation"
                                // et quitter le mode "Shutdown" (par défaut après power up)
                                // Voir datasheet page 13

// 1er test avec les 8 ports P19 à P12 en sorties sur 8 leds du bargraph
// Y'A PLUS QU'A CABLER ET TESTER!                               
    write_max7301(0x0B , 0x55); // Config. de P15P14P13P12 en sorties
    write_max7301(0x0C , 0x55); // Config. de P19P18P17P16 en sorties                             
    // Remarque : les 12 autres ports sont en entrées par défaut
    
    char i, chenill;                              
    
    while(1) {
              chenill = 0xFE; // Initialisation du chenillard (1111 1110)
              for (i = 0; i < 8; i++)  // Chenillard Aller...
               {
                write_max7301(0x4C , chenill); // 0x4C est l'adresse du port 8 bits P19-P12 en ecriture
                                               // Voir table3 datasheet page 11
                chenill = (chenill<<1) + 1 ; // Décalage à gauche du chenillard 
                                             // + mise à 1 du LSb.
                wait(0.2);  //waits a 200 ms 
               }            
              chenill = 0x7F; // Initialisation du chenillard (01111 1111)
              for (i = 0; i < 8; i++) // Chenillard Retour...
               { 
                write_max7301(0x4C , chenill); // 0x4C est l'adresse du port 8 bits P19-P12 en ecriture
                                               // Voir table3 datasheet page 11
                chenill = (chenill>>1) + 0x80 ; // Décalage à gauche du chenillard 
                                                // + mise à 1 du LSb.
                wait(0.2);  //waits a 200 ms 
               }
             }
}

// Définitions des fonctions
void write_max7301(char cde_adr, char reg_dat)
{
    cs_spi = 0;
    my_spi.write(cde_adr);
    my_spi.write(reg_dat);
    cs_spi = 1;
}