#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "BME280.h"

Serial pc(USBTX, USBRX);

#if defined(TARGET_LPC1768)
 BME280 sensor(PB_9, PB_8);
#else
 BME280 sensor(I2C_SDA, I2C_SCL);
#endif
TS_StateTypeDef TS_State;

DigitalOut    MUX0(D0); // low-active
DigitalOut    MUX1(D1); 

float x=0;
float Temp1=0;
float Temp2=0;
float Temp3=0;
uint8_t y=0;
uint8_t text[30];
uint8_t idx;
 
int main()
{
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    

    while (1) {
        

        BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
        BSP_LCD_SetTextColor(LCD_COLOR_ORANGE);
        
        MUX0 = 0;
        MUX1 = 0;
                
        HAL_Delay(50);
        
        x = sensor.getTemperature();
        Temp1 = sensor.getTemperature();
        sprintf((char*)text, "%2.2f deg C",x);
        BSP_LCD_DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, CENTER_MODE);
                
        MUX0 = 1;
        MUX1 = 0;
                
        HAL_Delay(50);
        
        x = sensor.getTemperature();
        Temp2 = sensor.getTemperature();
        sprintf((char*)text, "%2.2f deg C",x);
        BSP_LCD_DisplayStringAt(0, LINE(idx+5), (uint8_t *)&text, CENTER_MODE);
        
        HAL_Delay(50);
        
        MUX0 = 0;
        MUX1 = 1;
        
        x = sensor.getTemperature();
        Temp3 = sensor.getTemperature();
        sprintf((char*)text, "%2.2f deg C",x);
        BSP_LCD_DisplayStringAt(0, LINE(idx+9), (uint8_t *)&text, CENTER_MODE);
        
        HAL_Delay(50);
        
    }
}
