#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "BME280.h"
#include "F746_GUI.hpp"

Serial pc(USBTX, USBRX);

#if defined(TARGET_LPC1768)
 BME280 sensor(PB_9, PB_8);
#else
 BME280 sensor(I2C_SDA, I2C_SCL);
#endif
TS_StateTypeDef TS_State;

PwmOut        ena(D0);

DigitalOut    MUX0(D7); // low-active
DigitalOut    MUX1(D4); 
DigitalOut    MUX2(D1); 

float x1=0;
float Temp1=0;
float Temp2=0;
float Temp3=0;
float y1=0;
float z1=0;
uint8_t text[30];
uint8_t idx;
int num;
 
int main()
{
    float val;
    float percentage;
    
    ena.period(1.0/5000.0);// 4Khz period
        
    Label label1(350, 40, "Temp. microcontroller (C): ", Label::RIGHT, Font16);
    Label label2(285, 70, "Temp. batteries (C): ", Label::RIGHT, Font16);
    Label label3(240, 100, "Temp. motor (C): ", Label::RIGHT, Font16);                 
    
    SeekBar myBar(100, 200, 250, 25, 35, 30, "25", "30", "35");
    
    NumericLabel<float> myLabelbar(210, 150, "%5.2f", 30);
    NumericLabel<float> Temp1(350, 40, "%5.2f", 0);
    NumericLabel<float> Temp2(350, 70, "%5.2f", 0);
    NumericLabel<float> Temp3(350, 100, "%5.2f", 0);
    
    ButtonGroup bG(420, 196, 50, 36, 2, (string[]){"ON", "OFF"},0, 5, 1, 0);
    
        
    
    while (1) {    
        
        if (myBar.Slide())
        {
            val = myBar.GetValue();
            myLabelbar.Draw(val);
            printf("val = %f\r\n", val);
        }
        
        if (bG.GetTouchedNumber(num))
        {
            if (num == 0) myBar.Activate();
            else          myBar.Inactivate();
        }
               
        MUX0 = 0;
        MUX1 = 0;
        MUX2 = 0;
        
        BME280 sensor(I2C_SDA, I2C_SCL);        

        
        x1 = sensor.getTemperature();
        if(x1< 100 and x1>10){
        Temp1.Draw(x1);
        }
               
        MUX0 = 1;
        MUX1 = 0;
        MUX2 = 0;
                
        BME280 sensor1(I2C_SDA, I2C_SCL); 
        
        
        y1 = sensor1.getTemperature();
        if(y1<100 and y1>10){
        Temp2.Draw(y1);
        }
        
        MUX0 = 0;
        MUX1 = 1;
        MUX2 = 0;
        
        BME280 sensor2(I2C_SDA, I2C_SCL); 
        
        z1 = sensor2.getTemperature();
        
        if(z1<100 and z1>10){
        Temp3.Draw(z1);
        }
                
        if ( x1 > val){
             percentage= x1*0.01f;        
             ena.write(percentage);
        }
        else if (x1< val){
            ena.write(0.00f);
        }       
        
    }
}