#include "servo_gui.h"
#define PI 3.1415

ServoGui::ServoGui(void)
{
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.FillCircle(120, 120, 98);
    lcd.DrawCircle(30, 290, 20);
    lcd.DrawCircle(90, 290, 20);
    lcd.DrawCircle(150, 290, 20);
    lcd.DrawCircle(210, 290, 20);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillCircle(120, 120, 20);
    lcd.DrawLine(120, 120, 120+98, 120);
}

void ServoGui::LedOn(unsigned char ucLedIndex)
{
    lcd.SetTextColor(LCD_COLOR_WHITE);
    for(unsigned char ucLedCounter = 0; ucLedCounter < 4; ucLedCounter++) {
        lcd.FillCircle(30+ucLedCounter*60, 290, 19);
    }
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillCircle(30+ucLedIndex*60, 290, 19);
}

void ServoGui::LedStep(enum StepDirection eDirection)
{
    if(eDirection == LEFT) {
        ucLedCtr--;
    } else if(eDirection == RIGHT) {
        ucLedCtr++;
    }
    LedOn(ucLedCtr%4);
}

void ServoGui::MotorStep(enum StepDirection eDirection)
{
    if(eDirection == LEFT) {
        uiStepCounter--;
    } else if(eDirection == RIGHT) {
        uiStepCounter++;
    }
    dAngle = uiStepCounter % 360;
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.FillCircle(120, 120, 98);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DrawLine(120,120,120+98*cos(dAngle*PI/180), 120+98*sin(dAngle*PI/180));
    lcd.FillCircle(120, 120, 20);
}

void ServoGui::GuiStepLeft(void)
{
    LedStep(LEFT);
    MotorStep(LEFT);
    //wait(0.04);
}

void ServoGui::GuiStepRight(void)
{
    LedStep(RIGHT);
    MotorStep(RIGHT);
    //wait(0.04);
}

unsigned char ServoGui::ucReadDetector(void)
{
    if(dAngle == 0) {
        return 1;
    } else {
        return 0;
    }
}
