#include "servo.h"

enum DetectorState Servo::eReadDetector()
{
    if(MyGui.ucReadDetector()==1)
    {
        return ACTIVE;
    }
    else
    {
        return INACTIVE;
    }
}

Servo::Servo(float fStepDelay)
{   
    fDelay = fStepDelay;
    Callib();
}

void Servo::Callib(void)
{
    uiDesiredPosition = 0;
    uiCurrentPosition = 0;
    eState = CALLIB;
    while(eState != IDLE)
    {
        if(eReadDetector() == INACTIVE) {
            MyGui.GuiStepLeft();
        } else {
            eState = IDLE;
        }
        wait(fDelay);
    }
}

void Servo::GoTo(unsigned int uiPosition)
{
    uiDesiredPosition = uiPosition;
    eState = IN_PROGRESS;
    while(eState != IDLE){
        if(uiCurrentPosition > uiDesiredPosition) {
            uiCurrentPosition--;
            MyGui.GuiStepLeft();
        } else if(uiCurrentPosition < uiDesiredPosition) {
            uiCurrentPosition++;
            MyGui.GuiStepRight();
        } else if(uiCurrentPosition == uiDesiredPosition) {
            eState = IDLE;
        }
        wait(fDelay);
    }
}

void Servo::Step(unsigned int uiSteps)
{
    uiDesiredPosition = uiCurrentPosition + uiSteps;
    eState = IN_PROGRESS;
    while(eState != IDLE){
        if(uiCurrentPosition < uiDesiredPosition) {
            uiCurrentPosition++;
            MyGui.GuiStepRight();
        } else if(uiCurrentPosition == uiDesiredPosition) {
            eState = IDLE;
        }
        wait(fDelay);
    }
}