#include "servo.h"
#include "command_decoder.h"
#include "uart.h"

Servo MyServo(0.01);
Decoder MyDecoder;

int main()
{
    char cCommand[10];
    while(1)
    {
        gets(cCommand, sizeof(cCommand));
        MyDecoder.DecodeMsg(cCommand);
        if((MyDecoder.ucTokenNr > 0)&&(MyDecoder.asToken[0].eType == KEYWORD)) {
            switch(MyDecoder.asToken[0].uValue.eKeyword) {
                case ID:
                    puts("Device ID: 0x01\n", sizeof("Device ID: 0x01\n"));
                    break;
                case CLB:
                    MyServo.Callib();
                    puts("OK\n", sizeof("OK\n"));
                    break;
                case GOTO:
                    if(MyDecoder.asToken[1].eType == NUMBER) {
                        MyServo.GoTo(MyDecoder.asToken[1].uValue.uiNumber);
                        puts("OK\n", sizeof("OK\n"));
                    }
                    break;
                case STEP:
                    if(MyDecoder.asToken[1].eType == NUMBER) {
                        MyServo.Step(MyDecoder.asToken[1].uValue.uiNumber);
                        puts("OK\n", sizeof("OK\n"));
                    }
                    break;
                default:
                    break;
            }
        } else {
            puts("unknowncommand\n", sizeof("unknowncommand\n"));
        }
    }
}
