#ifndef SERVO_GUI_H
#define SERVO_GUI_H

#include "LCD_DISCO_F429ZI.h"

enum StepDirection {RIGHT, LEFT};

class ServoGui
{
    public:
        ServoGui(void);
        void GuiStepLeft(void);
        void GuiStepRight(void);
        unsigned char ucReadDetector(void);
    private:
        void LedOn(unsigned char);
        void LedStep(enum StepDirection);
        void MotorStep(enum StepDirection);
        LCD_DISCO_F429ZI lcd;
        unsigned char ucLedCtr;
        unsigned int uiStepCounter;
        double dAngle;
};

#endif