#ifndef COMMAND_DECODER_H
#define COMMAND_DECODER_H

#define MAX_KEYWORD_STRING_LTH 10
#define MAX_KEYWORD_NR 4
#define MAX_TOKEN_NR 3

enum KeywordCode {ID, CLB, GOTO, STEP};
enum TokenType { KEYWORD, NUMBER, STRING};

union TokenValue
{
    enum KeywordCode eKeyword; // jezeli KEYWORD
    unsigned int uiNumber; // jezeli NUMBER
    char *pcString; // jezeli STRING
};

struct Token
{
    enum TokenType eType; // KEYWORD, NUMBER, STRING
    union TokenValue uValue; // enum, unsigned int, char*
};

struct Keyword
{
    enum KeywordCode eCode;
    char cString[MAX_KEYWORD_STRING_LTH + 1];
};

class Decoder
{
    public:
        void DecodeMsg(char *pcString);
        
        struct Token asToken[MAX_TOKEN_NR];
        unsigned char ucTokenNr;
    private:
        unsigned char ucFindTokensInString(char *pcString);
        enum Result eStringToKeyword(char pcStr[],enum KeywordCode *peKeywordCode);
        void DecodeTokens(void);
        
        union TokenValue uTokenValue;
        struct Keyword sKeyword;
        
};
#endif