#include "Ledboard.h"
#include "LCD_DISCO_F429ZI.h"

extern LCD_DISCO_F429ZI lcd;

Ledboard::Ledboard(unsigned char ucColumn){
    lcd.SetFont(&Font24);
    lcd.Clear(LCD_COLOR_BLACK);
    for(unsigned char ucRow = 0; ucRow < 4; ucRow++) {
        Leds[ucRow] = new Led(ucColumn, ucRow);
    }
}

void Ledboard::On(unsigned char ucRow){
    Off();
    Leds[ucRow] -> On();
}

void Ledboard::Off(void){
    for(unsigned char ucRow = 0; ucRow<4; ucRow++){
        Leds[ucRow] -> Off();
    }
}
