#include "Led.h"

extern LCD_DISCO_F429ZI lcd;

Led::Led(unsigned char ucColumn, unsigned char ucRow){
    this->ucColumn = ucColumn;
    this->ucRow = ucRow;
    Off();
}

void Led::On(void){
    Redraw(LCD_COLOR_YELLOW);
}

void Led::Off(void){
    Redraw(LCD_COLOR_BLUE);
}


void Led::Redraw(uint32_t Color){
    char pcLedNumber[1];
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(ucColumn * 80, ucRow * 80, 80, 80);
    lcd.SetTextColor(Color);
    lcd.FillRect(1 + ucColumn * 80, 1 + ucRow * 80, 78, 78);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_RED);
    sprintf((char*)pcLedNumber, "%d", ucRow);
    lcd.DisplayStringAt(ucColumn * 80, ucRow * 80, (uint8_t *)pcLedNumber, LEFT_MODE);
}