/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include <string>
#include <MQTTClientMbedOs.h>
#include "TextLCD.h"
#include "rohm-sensor-hal/rohm-sensor-hal/rohm_hal.h"       //mbed.h, types, DEBUG_print*
#include "rohm-sensor-hal/rohm-sensor-hal/I2CCommon.h"

#include "rohm-rpr0521/rohm-rpr0521/rpr0521_driver.h"
#include "rohm-rpr0521/rohm-rpr0521/rpr0521.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

Serial pc(USBTX,USBRX);
InterruptIn button(USER_BUTTON);
int arrivedcount = 0;
TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;
int button_pressed=0;

char* topic_sub = "PMK_industrija/micro1/#";
char* topic_pub1 = "PMK_industrija/micro1/proxy1";
char* topic_pub2 = "PMK_industrija/micro2/proxy1";
char* topic_pub3 = "PMK_industrija/micro2/servo0";
WiFiInterface *wifi;

TextLCD lcd(D2,D3,D4,D5,D6,D7);
DigitalOut vdd(D8);

volatile int mems_event = 0;
uint32_t previous_tick = 0;
uint32_t current_tick = 0;
uint8_t high = 0, low = 0;
float temperature = 0.0f;
char buffer[32];
int plava = 0;
int zuta = 0;
int zelena = 0;
int crvena = 0;
int drugaBoja = 0;
static char *print_double(char *str, double v, int decimalDigits = 2)
{
    int i = 1;
    int intPart, fractPart;
    int len;
    char *ptr;
 
    /* prepare decimal digits multiplicator */
    for (; decimalDigits != 0; i *= 10, decimalDigits--);
 
    /* calculate integer & fractinal parts */
    intPart = (int)v;
    fractPart = (int)((v - (double)(int)v) * i);
 
    /* fill in integer part */
    sprintf(str, "%i.", intPart);
 
    /* prepare fill in of fractional part */
    len = strlen(str);
    ptr = &str[len];
 
    /* fill in leading fractional zeros */
    for (i /= 10; i > 1; i /= 10, ptr++) {
        if (fractPart >= i) {
            break;
        }
        *ptr = '0';
    }
 
    /* fill in (rest of) fractional part */
    sprintf(ptr, "%i", fractPart);
 
    return str;
}

const char *sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;
    printf("Scan:\n");
    int count = wifi->scan(NULL,0);
    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;
    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    for (int i = 0; i < count; i++) {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }
    printf("%d networks available.\n", count);
    delete[] ap;
    return count;
}

void messageArrived(MQTT::MessageData& md)
{
    MQTTString &topic = md.topicName;
    string topic_name = topic.lenstring.data;
    printf("Topic name %d : %s\r\n",topic.lenstring.len,topic_name.c_str() );
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\r\n", message.payloadlen, (char*)message.payload);
    string poruka = (char*)message.payload;
    if(topic_name.find("proxy1")!=std::string::npos) {
        printf("Ima cepa!!! \r\n"); 
        
        char buf[100];
        sprintf(buf, "Daj mi boju tu je cep");
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf)+1;
        client.publish(topic_pub2, message);    
                
    }
    if(topic_name.find("color")!=std::string::npos) {
        printf("Vidi boje!!! \r\n"); 
        bool levo = false;
        
        if (poruka.find("CRVENA") !=std::string::npos){
                levo = true;
                crvena++;
        }
        else if (poruka.find("ZELENA") !=std::string::npos){
                zelena++;
        }
        else if (poruka.find("PLAVA") !=std::string::npos){
                plava++;
        }
        else if (poruka.find("ZUTA") !=std::string::npos){
                zuta++;
        }else {
                drugaBoja++;
            }
        char buf[100];
                
        sprintf(buf, "Otvaraj taj servo PS =%b",levo );
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf)+1;
        client.publish(topic_pub3, message);    
        lcd.cls();
        lcd.printf("c:%d  p:%d z:%d\ny:%d dr:%d",crvena,plava,zelena,zuta,drugaBoja);
    }
    ++arrivedcount;
}


void buttonFunction() {    
    button_pressed=1;   
}

void rpr0521_print_one_value(){
    bool error;
    uint16_t data[3];
    
    error = rpr0521_read_data(&data[0]);
    if (!error) {
        printf("PS[%4u], Als0[%4u], Als1[%4u]\n\r", data[0], data[1], data[2]);
        }
    else {
        printf("\n\r");
        }
}
int main()
{
    // Initialise the digital pin LED1 as an output
    bool error;
    uint16_t dataProx[3];
    DigitalOut led(LED1); 
    button.rise(&buttonFunction);
    const char* hostname = "broker.mqttdashboard.com";
    int port = 1883;    
    DigitalOut d8(D8);
    d8 = 1;
    DigitalOut d12(D12);
    d12 = 0;
    DigitalOut d13(D13);
    d13 = 1;
    
    I2CCommonBegin();
    rpr0521_wait_until_found();
    pc.printf("\nSensor found.\n\r");
    rpr0521_initial_setup();
    
    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        printf("ERROR: No WiFiInterface found.\n");
        return -1;
    }

    int count = scan_demo(wifi);
    if (count == 0) {
        printf("No WIFI APs found - can't continue further.\n");
        return -1;
    }

    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error: %d\n", ret);
        return -1;
    }

    printf("Success\n\n");
    printf("MAC: %s\n", wifi->get_mac_address());
    printf("IP: %s\n", wifi->get_ip_address());
    printf("Netmask: %s\n", wifi->get_netmask());
    printf("Gateway: %s\n", wifi->get_gateway());
    printf("RSSI: %d\n\n", wifi->get_rssi());

    socket.open(wifi);
    socket.connect(hostname, port);
    
    int rc=0;
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "PMK-client2";
    //data.username.cstring = "testuser";
    //data.password.cstring = "testpassword";
    
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);

    
    if ((rc = client.subscribe(topic_sub, MQTT::QOS2, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\r\n", rc);    
    
    
    
    while (true) {
        led = !led;
        thread_sleep_for(BLINKING_RATE_MS);
     
    
        error = rpr0521_read_data(&dataProx[0]);
        if (!error){
            if(dataProx[0] > 50) {
                printf("Pristigao je cep na lokaciju O.O O:'( \r\n ");
                char buf[100];
                sprintf(buf, "Cep je pristigao na proxy1 PS = %d",dataProx[0]);
                message.qos = MQTT::QOS0;
                message.retained = false;
                message.dup = false;
                message.payload = (void*)buf;
                message.payloadlen = strlen(buf)+1;
                client.publish(topic_pub1, message);    
                
                }
        
        }
        if (button_pressed==1) {
            button_pressed=0;    
            printf("Publishing data\r\n");    
            // QoS 0
            char buf[100];
          
            //sprintf(buf, "RGB: %7s C\r\n", print_double(buffer, cs.getRed()*100000000+cs.getGreen()*10000+cs.getBlue()));
            
           //message.qos = MQTT::QOS0;
            //message.retained = false;
            //message.dup = false;
            //message.payload = (void*)buf;
            //message.payloadlen = strlen(buf)+1;
            //client.publish(topic_pub, message);
            
        }
       // printf("Yielding"); 
        client.yield(1000);
        //printf(" -> Yielded\r\n"); 
    }
}
