/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */
#include "Function.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

Serial pc(USBTX,USBRX);
InterruptIn button(USER_BUTTON);
int arrivedcount = 0;

int button_pressed=0;



WiFiInterface *wifi;


volatile int mems_event = 0;
uint32_t previous_tick = 0;
uint32_t current_tick = 0;

char buffer[32];

enum Boja {CRVENA,ZELENA,PLAVA,DRUGA};
Boja BojaCepa[3]; 
Timeout Tmicro2,Tmicro3,Tmicro4;
bool echoFlag[3];



void timeoutMCU1(){
    Tmicro2.detach();
    if (!echoFlag[0]){
        printf("Nema odgovora sa micro1!\r\n");
        printf("Pokusaj ponovnog kacenja na sve kontrolere\r\n");
        //Upadam u while??? Nista se ne desava dok se ne uspostavi konekciju??
        lcdUpdate("MCU1_FAIL");
        checkOtherConnections();
        }
    }




void messageArrived(MQTT::MessageData& md)
{   
    char buf[100];
    MQTTString &topic = md.topicName;
    string topic_name = topic.lenstring.data;
    printf("Topic name %d : %s\r\n",topic.lenstring.len,topic_name.c_str() );
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\r\n", message.payloadlen, (char*)message.payload);
    string poruka = (char*)message.payload;
    if(topic_name.find("proxy1")!=std::string::npos) {
        printf("Ima cepa!!! proxy1 \r\n");         
        sprintf(buf, "Daj mi boju tu je cep");
        publish(client,topic_pub_m2_color1,buf);
        echoFlag[0] = false; 
        Tmicro2.attach(&timeoutMCU1,5.0);               
    }
    else if(topic_name.find("color1")!=std::string::npos) {
        printf("Vidi boje !!! color1 \r\n"); 
        if (colorCheck(poruka,crvena,topic_pub_m2_servo1)) lcdUpdate("CRVENA");
        servo0Flag = true;
    }
    else if(topic_name.find("proxy2")!=std::string::npos) {
        printf("Ima cepa!!! proxy2 \r\n");         
        sprintf(buf, "Daj mi boju tu je cep");
        publish(client,topic_pub_m3_color2,buf); 
    }
    else if(topic_name.find("color2")!=std::string::npos) {
        printf("Vidi boje !!! color2 \r\n"); 
        if(colorCheck(poruka,zelena,topic_pub_m3_servo2)) lcdUpdate("ZELENA");
        
    }
    else if(topic_name.find("proxy3")!=std::string::npos) {
        printf("Ima cepa!!!proxy3 \r\n");         
        sprintf(buf, "Daj mi boju tu je cep");
        publish(client,topic_pub_m3_color2,buf);
         
    }
    else if(topic_name.find("color3")!=std::string::npos) {
        printf("Vidi boje !!! color3 \r\n"); 
        if(colorCheck(poruka,zelena,topic_pub_m4_servo3)){lcdUpdate("PLAVA");}
        else {drugaBoja++; lcdUpdate("DRUGA");}
    }
    else if(topic_name.find("connect2")!=std::string::npos) microOnline(2);
    else if(topic_name.find("connect3")!=std::string::npos) microOnline(3);
    else if(topic_name.find("connect4")!=std::string::npos) microOnline(4);
    ++arrivedcount;
}


void buttonFunction() {    
    button_pressed=1;   
}

int main()
{
    // Initialise the digital pin LED1 as an output
   
    DigitalOut led(LED1); 
    const char* hostname = "broker.mqttdashboard.com";
    int port = 1883;    
   

    
    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        printf("ERROR: No WiFiInterface found.\n");
        return -1;
    }

    int count = scan_demo(wifi);
    if (count == 0) {
        printf("No WIFI APs found - can't continue further.\n");
        return -1;
    }

    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error: %d\n", ret);
        return -1;
    }

    printf("Success\n\n");
    printf("MAC: %s\n", wifi->get_mac_address());
    printf("IP: %s\n", wifi->get_ip_address());
    printf("Netmask: %s\n", wifi->get_netmask());
    printf("Gateway: %s\n", wifi->get_gateway());
    printf("RSSI: %d\n\n", wifi->get_rssi());

    socket.open(wifi);
    socket.connect(hostname, port);
    
    int rc=0;
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "PMK-industrija-master";
    //data.username.cstring = "testuser";
    //data.password.cstring = "testpassword";
    
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);

    
    if ((rc = client.subscribe(topic_sub, MQTT::QOS2, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\r\n", rc);    
    
    
    checkOtherConnection();
    
    char buf[100];
    
    while (true) {
        led = !led;
        thread_sleep_for(BLINKING_RATE_MS);
        
        if (servo0Flag){
            servo0Flag = false;
            sprintf(buf,"Otvori");
            publish(client,topic_pub_m2_servo0,buf);            
        }
        
        
        if (button_pressed==1) {
            button_pressed=0;    
            printf("Publishing data\r\n");    
            // QoS 0
            
          
            //sprintf(buf, "RGB: %7s C\r\n", print_double(buffer, cs.getRed()*100000000+cs.getGreen()*10000+cs.getBlue()));
            
            
        }
       // printf("Yielding"); 
        client.yield(1000);
        //printf(" -> Yielded\r\n"); 
    }
}
