#include "mbed.h"
#include "platform/mbed_thread.h"
#include <string>
#include <MQTTClientMbedOs.h>

#define TOPIC_SUB "PMK_industrija/micro1/#"

char* topic_sub = "PMK_industrija/micro1/#";

char* topic_pub_m2_connect = "PMK_industrija/micro2/connect";
char* topic_pub_m3_connect = "PMK_industrija/micro3/connect";
char* topic_pub_m4_connect = "PMK_industrija/micro4/connect";

char* topic_pub_m2_servo0 = "PMK_industrija/micro2/servo0";
char* topic_pub_m2_color1 = "PMK_industrija/micro2/color1";
char* topic_pub_m2_servo1 = "PMK_industrija/micro2/servo1";
char* topic_pub_m3_proxy1 = "PMK_industrija/micro3/proxy1";
char* topic_pub_m3_proxy2 = "PMK_industrija/micro3/proxy2";
char* topic_pub_m3_servo2 = "PMK_industrija/micro3/servo2";
char* topic_pub_m3_color2 = "PMK_industrija/micro3/color2";
char* topic_pub_m4_servo3 = "PMK_industrija/micro4/servo3";
char* topic_pub_m4_proxy3 = "PMK_industrija/micro4/proxy3";
char* topic_pub_m4_color3 = "PMK_industrija/micro4/color3";
char* topic_pub_m4_LCD = "PMK_industrija/micro4/LCD";


TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;
bool connectFlag[3] = {false,false,false};
bool allConnected = false;




static char *print_double(char *str, double v, int decimalDigits = 2)
{
    int i = 1;
    int intPart, fractPart;
    int len;
    char *ptr;
 
    /* prepare decimal digits multiplicator */
    for (; decimalDigits != 0; i *= 10, decimalDigits--);
 
    /* calculate integer & fractinal parts */
    intPart = (int)v;
    fractPart = (int)((v - (double)(int)v) * i);
 
    /* fill in integer part */
    sprintf(str, "%i.", intPart);
 
    /* prepare fill in of fractional part */
    len = strlen(str);
    ptr = &str[len];
 
    /* fill in leading fractional zeros */
    for (i /= 10; i > 1; i /= 10, ptr++) {
        if (fractPart >= i) {
            break;
        }
        *ptr = '0';
    }
 
    /* fill in (rest of) fractional part */
    sprintf(ptr, "%i", fractPart);
 
    return str;
}

const char *sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;
    printf("Scan:\n");
    int count = wifi->scan(NULL,0);
    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;
    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    for (int i = 0; i < count; i++) {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }
    printf("%d networks available.\n", count);
    delete[] ap;
    return count;
}

void publish(MQTTClient client, char* topic, char* buf ){
        MQTT::Message message;
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf)+1;
        client.publish(topic, message);    
    
    }

void microOnline(int n){ 
    connectFlag[n-2] = true;
    for(int i =0 ; i < 3; i++){
        if(!connectFlag[n-2]) return;
    }
    allConnected = true;
}

void checkOtherConnection(){
        char buf[100];
        sprintf(buf, "Jesi li online?");
        while(true){
            printf("Porovera konekcije ostalih uredjaja! \r\n");    
            publish(client,topic_pub_m2_connect,buf);
            publish(client,topic_pub_m3_connect,buf);
            publish(client,topic_pub_m4_connect,buf);
            wait(60);
            if (allConnected) {
                break;
                printf("SVI UREDJAJI SU ONLINE \r\n");
            }
            printf("Nisu svi povezani\r\n\r\n");
        }
    }


bool colorCheck(string poruka,int &boja,char* topic){
        char buf[100];
        bool levo = false;
        if (poruka.find("Jeste") !=std::string::npos) {levo = true; boja++; }
        sprintf(buf, "%b",levo );
        publish(client,topic,buf);
        if(levo) return true;
        return false;
    }
void lcdUpdate(char* Boja){
      publish(client,topic_pub_m4_LCD,Boja);  
    }