/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"//uvoz biblioteka

#define SCALER 4900//definisanje direktiva

AnalogIn pot1(PA_0);//glavne promenljive
AnalogIn pot2(PA_1);
PwmOut buzz(PA_11);
InterruptIn sw1(PC_9);
BusOut display(PA_10,PA_9,PA_8,PB_10,PB_5,PB_4,PB_3,PA_5);
DigitalOut SEL2(PC_7);
DigitalOut SEL1(PB_6);

void ISR_sw1(void);//pomocne funkcije

int main()//glavna funkcija
{
    buzz.period_ms(1);
    sw1.fall(&ISR_sw1);
    while (true) {
        buzz.period_us(pot2.read()*SCALER+100);//kada stavim 50 pocetnu vrednost ne cuje se po cetak pa zato sam stavio 100us
        buzz.write(pot1.read());
        wait_ms(10);
    }
}

void ISR_sw1()//interrupt sub-routine
{
        int i=pot1.read()*100;
        
            int d;
            int j;
            d=i/10;
            j=i%10;
        while(!sw1.read())
        {
            if(i<10)
        {
            SEL2.write(0);
            switch(i)
        {
           case 0:display.write(0xC0);break;
           case 1:display.write(0xF9);break;
           case 2:display.write(0xA4);break;
           case 3:display.write(0xB0);break;
           case 4:display.write(0x99);break;
           case 5:display.write(0x92);break;
           case 6:display.write(0x82);break;
           case 7:display.write(0xF8);break;
           case 8:display.write(0x80);break;
           case 9:display.write(0x90);break;
           
        }
        SEL2.write(1);
        wait_us(500);
        }
        else
        {
        SEL1.write(0);
        switch(d)
        {
           case 1:display.write(0xF9);break;
           case 2:display.write(0xA4);break;
           case 3:display.write(0xB0);break;
           case 4:display.write(0x99);break;
           case 5:display.write(0x92);break;
           case 6:display.write(0x82);break;
           case 7:display.write(0xF8);break;
           case 8:display.write(0x80);break;
           case 9:display.write(0x90);break;
           
        }
        wait_us(500);
        
        SEL1.write(1);
        
        SEL2.write(0);
        switch(j)
        {
           case 0:display.write(0xC0);break;
           case 1:display.write(0xF9);break;
           case 2:display.write(0xA4);break;
           case 3:display.write(0xB0);break;
           case 4:display.write(0x99);break;
           case 5:display.write(0x92);break;
           case 6:display.write(0x82);break;
           case 7:display.write(0xF8);break;
           case 8:display.write(0x80);break;
           case 9:display.write(0x90);break;
           
        }
        wait_us(500);
        SEL1.write(1);
        }
        }
        
        
}
