#include "mbed.h"
#include "EthernetInterface.h"

 
const int ECHO_SERVER_PORT = 7;
const char* ECHO_SERVER_ADDRESS = "10.3.2.164";
 
 
double ref = 20;
double temperatura;
 
Thread tcp_server;
Thread tcp_client;
Thread leitura;
Thread controle;

Mutex m_temp;
Mutex m_ref;
 
EthernetInterface eth;
 
void tcp_server_thread ();
void tcp_client_thread ();
void tcp_client_send_temp ();
void leitura_thread();
void controle_thread();

AnalogIn LM35(A0);
PwmOut PWM1(A5);
 
int main (void) {
    //inicializa o módulo ethernet
    eth.init();
    eth.connect();
   
    //inicializa o PWM
    PWM1.period_ms(100);
   
    //para não enviar a temperatura
    tcp_client.signal_clr(0x1);
   
    /** INICIALIZAÇÃO DAS THREADS **/
    tcp_server.start(tcp_server_thread);
    tcp_client.start(tcp_client_thread);
    leitura.start(leitura_thread);
    controle.start(controle_thread);
   
    while (true) {
        
    }
}
 
void tcp_server_thread () {
    printf("\nServer IP Address is %s\n", eth.getIPAddress());
   
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
   
    while (true) {
        printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
       
        printf("\nConnection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
           
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\n",buffer);
           
            m_ref.lock();
            ref = atof(buffer);
            sprintf (buffer, "%f", ref);
            m_ref.unlock();
           
            // print sending message to terminal
            printf("Sending message to Client: '%s'\n",buffer);
           
            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
       
        client.close();
    }
}
 
void tcp_client_thread () {
    printf("\nClient IP Address is %s\n", eth.getIPAddress());
   
    while(true) {
        Thread::signal_wait(0x1);
        tcp_client_send_temp();
    }
}
 
void tcp_client_send_temp () {
    // Connect to Server
    TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, 5000) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, 5000);
        Thread::wait(1000);
    }
    //printf("Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
   
    // Send message to server
    char buffer[10];
    int num; 
    
    m_temp.lock();
    num = sprintf (buffer, "%.1f", temperatura);
    m_temp.unlock();
    
    //printf("Sending  message to Server : '%s' \n",buffer);
    socket.send_all(buffer, num);
   
    // Receive message from server
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';
    //printf("Received message from server: '%s'\n", buf);
   
    // Clean up
    socket.close();
}
 
void leitura_thread () {
    double meas;
    while (true) {
        meas = LM35.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        
        m_temp.lock();
        temperatura = meas * 330; // (0,1) * 3.3 (para converter pra tensão) / 10mV por grau celsius pra temperatura
        m_temp.unlock();
        
        tcp_client.signal_set(0x1);    //AVISA TCP_CLIENT Q PODE ENVIAR SOCKET
        
        Thread::wait(1000);
    }
}

void controle_thread(){
    int tempo = 0;
    
    double deltaVo, ref_tensao, erro, saidaatual, saidaantiga = 0;
    
    while(true){
        deltaVo = temperatura * 0.01;   // para converter para tensão
        deltaVo = deltaVo - 0.26;   // para virar delta
        
        m_ref.lock();
        printf("ref = %.1f\n", ref);
        ref_tensao = ref * 0.01 - 0.26; // 10mV/grau
        m_ref.unlock();
        
        erro = ref_tensao - deltaVo;    //calcula o erro
        saidaatual = 625 * erro + 0.5 * saidaantiga;   // em tensão
        saidaantiga = saidaatual;
        saidaatual = saidaatual / 3.3;  // converte para duty cycle
        PWM1.write(saidaatual);
        
        m_temp.lock();
        printf("temp(%d) = %.1f graus\n", tempo, temperatura);
        m_temp.unlock();
        
        tempo++;
        Thread::wait(1000); // 1s
    }
 
 }
 