/* mbed TextStar serial LCD Library
 * Copyright (c) 2009-2010 Paul Griffith
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * Last edit: 10 Jan 2010
 *
 * TextStar CW-LCD-02 16x2 serial LCD module
 * Cat's Whisker Technologies, http://www.cats-whisker.com 
 */

#include "mbed.h"

#ifndef MBED_TEXTSTAR_H
#define MBED_TEXTSTAR_H

class TextStar : public Serial {
public:

    TextStar(PinName tx, PinName rx);

   //printf(), putc(), baud() etc are inherited from Serial
    
    //basic commands common to all mbed Text Display libraries

    void cls();
    void locate(int column, int row);
    void foreground(int colour);
    void background(int colour);

    //TextStar specific commands
                
    void reset(int autoblank =1, int autoscroll =1);
    void left();
    void right();
    void down();
    void up();
    void home();
    void crlf();
    void del();
    void set_cursor(int style);
    void window(int line);
    void scroll_up();
    void scroll_down();
    void bar_graph(int capped, int length, int percentage);
    void custom_char(int num, char *bitmap);
    void version();
    void send_version();
    void send_keys();

protected:

    int _autoblank, _autoscroll;

};

#endif
