/* mbed TextStar serial LCD Library
 * Copyright (c) 2009-2010 Paul Griffith 
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * Last edit: 10 Jan 2010
 *  
 * TextStar CW-LCD-02 16x2 serial LCD module
 * Cat's Whisker Technologies, http://www.cats-whisker.com 
 */
 
#include "TextStar.h"
#include "mbed.h"


TextStar::TextStar(PinName tx, PinName rx) : Serial(tx, rx) {
    reset();
}

void TextStar::cls() {
    //clear screen = 254,'S'
    //does not affect auto-blank and auto-scroll
    this->putc('\014');
}

void TextStar::locate(int column, int row) {
    //position cursor = 254,'P',line (0-15), col (0-15) 
    this->printf("\376P%c%c", row + 1, column + 1);
}

void TextStar::foreground(int colour) {
    //colours not supported
}

void TextStar::background(int colour) {
    //colours not supported
}

void TextStar::reset(int autoblank, int autoscroll) {
    //reset screen = 254,'R'
    this->printf("\376R");
    //set up auto-blank and auto-scroll as per arguments
    _autoblank = (autoblank == 0) ? 0 : 1;
    _autoscroll = (autoscroll == 0) ? 0 : 1;
    this->printf("\376G%c", 1 + (_autoblank * 64) + (_autoscroll * 64) );
//    this->printf("AB = %d AS = %d", _autoblank, _autoscroll);
//    wait(2.0);
//    cls();
}

void TextStar::left(void) {
    //move cursor left = 8
    this->putc('\010');
}

void TextStar::right(void) {
    //move cursor right = 9
    this->putc('\011');
}

void TextStar::down(void) {
    //move cursor down one line = 10
    this->putc('\012');
}

void TextStar::up(void) {
    //move cursor up one line = 11
    this->putc('\013');
}

void TextStar::home(void) {
    //cursor home = 254,'H'
    this->printf("\376H");
}

void TextStar::crlf(void) {
    //carriage return = 13
    this->putc('\015');
}

void TextStar::del(void) {
    //delete character = 127
    this->putc('\177');
}

void TextStar::set_cursor(int style) {
    //styles: 0 = none, 1 = solid block, 2 = flash block, 3 = solid uline, 4 = flash uline
    if (style < 0 || style > 4)
        return;
    this->printf("\376C%c", style);
}

void TextStar::window(int line) {
    //move visible window to line (0-14)
    if (line < 0 || line > 14)
        return;
    this->printf("\376G%c", line + 1 + (_autoblank * 64) + (_autoscroll * 128) );
}

void TextStar::scroll_up(void) {
    //move visble window up one line
    this->printf("\376O%c", 1);
}

void TextStar::scroll_down(void) {
    //move visible window down one line
    this->printf("\376O%c", 0);
}

void TextStar::bar_graph(int capped, int length, int percentage) {
    if (length < 1 || length > 16) {
        this->printf("Bad len %d", length);
        wait(2.0);
        return;
    }
    if (percentage < 0 || percentage > 100) {
        this->printf("Bad val %d", percentage);
        wait(2.0);
        return;
    }
    this->printf("\376%c%c%c", (capped == 0)? 'B' : 'b', length, percentage);
} 

void TextStar::custom_char(int num, char *bitmap) {
    //define custom character = 254,'D',bm1,bm2,bm3,bm4,bm5,bm6,bm7,bm8
    if (num < 128 || num > 135) {
        this->printf("Bad CC num %d", num);
        wait(2.0);
        return;
    }
    this->printf("\376D%c%c%c%c%c%c%c%c%c", num, bitmap[0], bitmap[1], bitmap[2], bitmap[3],
        bitmap[4], bitmap[5], bitmap[6], bitmap[7]);    
}

void TextStar::version(void) {
    //display firmware version and custom characters = 254,'V'
    this->printf("\376V");
}

void TextStar::send_version(void) {
    //send firmware version = 254,'v'
    this->printf("\376v");
}

void TextStar::send_keys(void) {
    //send key states = 254,'K'
    this->printf("\376K");
}