/******************************************************************************
 * File:      main.cpp
 * Author:    Paul Griffith
 * Created:   25 Mar 2014
 * Last Edit: see below
 * Version:   see below
 *
 * Description:
 * Test program for PwmSound class.
 *
 * Copyright (c) 2014 Paul Griffith, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 * Modifications:
 * Ver  Date    By  Details
 * 0.00 25Mar14 PG  File created.
 * 1.00 30Mar14 PG  Initial release.
 * 2.00 06May14 PG  Many changes and additions to test V2.00 library.
 *
 ******************************************************************************/

#include "mbed.h"
#include "PwmSound.h"

PwmSound mySpeaker(p24);    
Serial pc(USBTX, USBRX);

void printHelps(void);
void badArgs(void);
void nyi(void);
void pause(void);

// Tone fragments

#define DOODLY "O3>CG8G8AGPB>C"
#define YAY "O4L32MLCDEFG"		//success
#define WAH "T80O2L32GFEDC"		//failure

// Preset melodies in MML format
// Melodies 0-3 are taken from Michael J. Mefford's MS-DOS PLAY utility which
// was published as part of a PC Magazine cover disk in 1992.

// Super Mario Brothers theme (11 notes)

char* smb = {
	"T180 O3 E8 E8 P8 E8 P8 C8 D#4 G4 P4 <G4 P4"
};

char* preset0 = {       //short Dragnet theme
    "T90 O2 L8E. L16F# L8G E P2 L8E. L16F# L8G E L3 B-"
};

char* preset1 = {       //long Dragnet theme
    "T190O2L4EL8EL4MLG.MNL4G.EL8GL4AL8AL4MLG.MNL2G.L4EL8EL4MLG.MNL4G.EL8GL4AL8AL4MLG."
    "MNL2G.T90L8E.L16F#L8GEP2L8E.L16F#L8GEL3B-"
};

char* preset2 = {       //Greensleeves
    "O3A O4L2CL4D E.L8FL4E L2DL4O3B G.L8AL4B O4L2CO3L4A A.L8G#L4A L2BL4G# O3L2EL4A"
    "O4L2CL4D E.L8FL4E L2DL4O3B G.L8AL4B O4L4C.O3L8BL4A L4G#.L8F#L4G# L2A. L2A."
    "O4L2G. L4G.L8F#L4E L2DO3L4B G.L8AL4B L2O4CO3L4A A.L8G#L4A L2BL4G# L2E."
    "O4L2G. L4G.L8F#L4E L2DO3L4B G.L8AL4B O4L4C.O3L8BL4A G#.L8F#L4G# L2A. A."
};

char* preset3 = {		//The Entertainer by Scott Joplin
	":The Entertainer by Scott Joplin\n"	//comment lines need a \n
	""
	"T80            :Prelude\n"
	""
	"O4MLL64C#MNL16DECO3L8AL16BMSL8G"
	"MLL64C#MNL16DECO2L8AL16BL8MSGMN"
	"O2MLL64C#MNL16DECO1L8AL16BAA-"
	"MSL8GMNP4O3L8GO2L16MLDMND#"
	""
	"MLO2L16EMSL8O3CMLO2L16EO3MSL8C"
	"MNO2L16EO3L4C.L16O4CDD#"
	"ECDL8EL16O3BO4MSL8D"
	"MNCL16O3MLEGO4MSL8CMLO2L16DMND#"
	"MLO2L16EMSL8O3CMLO2L16EO3MSL8C"
	"MLO2L16EO3L4C.L16MLAMNG"
	"F#AO4CL8EL16DCO3A"
	"O4L4D.O1L16MLDMND#"
	"MLO2L16EMSL8O3CMLO2L16EO3MSL8C"
	"MNO2L16EO3L4C.L16O4CDD#"
	"ECDL8EL16O3BO4MSL8D"
	"MNCL16O3MLEGO4MSL8CMNL16CD"
	"ECDL8EL16CDC"
	"ECDL8EL16CDC"
	"ECDL8EL16O3BO4L8MSDMN"
	"L5MLC.MNL16O3EFF#"
	""
	"O3L8MSGMNL16AL8GL16EFF#"
	"MSL8GMNL16AL8GL16MSECO2G"
	"MLL16ABO3CDEDCD"
	"MNO2GMLO3EFGAGEMNF"
	"L8MSGMNL16AL8GL16EFF#"
	"L8MSGMNL16AL8GL16GAA#"
	"BL8BL16L8BL16AF#D"
	"L5MLG.MNL16EFF#"
	"MSL8GMNL16AL8GL16EFF#"
	"L8MSGMNL16AL8GL16MLECO3MNG"
	"MLABO4CDEDCD"
	"MSL8MLCL16EGMSO5CO4MNGF#G"
	"MSO5L8CO4MNL16AO5L8CL16O4AO5CO4A"
	"GO5CEL8GL16ECO4G"
	"MSL8AO5CMNL16EL8D"
	"L4C..L16O4EFF#"
	"MSL8GMNL16AL8GL16EFF#"
	"L8GL16AL8GL16MSECO3G"
	"MNABO4CDEDCD"
	"O3GO4EFGAGEF"
	"MSL8GMNL16AL8GL16EFF#"
	"L8GL16AL8GL16GAA#"
	""
	"BL8BBL16AF#D"
	"MLL64GAGAGAGAGAGAGAGAGL16MNEFF#"
	"L8MSGL16AL8GL16EFF#"
	"L8GL16AL8GL16MSECO3G"
	"MNABO4CDEDCD"
	"MSL8CL16MLEGO5MNCO4GF#G"
	"O5MSL8CO4MNL16AMLO5L8CL16O4AO5"
	"CO4AGO5CEL8GL16ECO4G"
	"L8MSAO5CMNL16EL8DL16MLC"
	"L4CL8C"
};

// The M.GAKKOU KOUKA
// copyright "Music Composed by Kenkichi Motoi 2009 Wikimedia version 2012"

char* preset4 = {	//play with sticky shift?
	"T160 O3L4"
	"ED8CE8 GG8ER8 AA8>C<A8 G2R"
	"AA8GA8 >CC8D<R8 EE8DE8 C2R"
	"DD8DD8 DD8DR8 ED8EF8 G2R"
	"AA8GA8 >CC8<AR8 >DC8DE8 D2<R"
	">EE8DC8< AB8>CC8< GG8EA8 G2R"
	">CC8<GE8 CD8EA8 GG8DE8 C2R"
};

int main()
{
	char buf[40];
    int i, n;
    Timer t;

    pc.printf("\nPWM Sound Demo 8, %s %s\n", __DATE__, __TIME__);
    mySpeaker.play(DOODLY);

    while(1) {
        pc.printf("Enter command (? for help): ");
        n = pc.getc();
        pc.printf("%c", n);
        if (n == '?') {
            pc.printf("\n");
            printHelps();
        } else if (n =='0') {
            mySpeaker.siren(0);
        } else if (n == '1') {
            i = pc.getc() - '0';
            pc.printf("%d", i);
            mySpeaker.play(YAY);
        } else if (n == '2') {
            i = pc.getc() - '0';
            pc.printf("%d", i);
            mySpeaker.play(WAH);
        } else if (n == '3') {
            i = pc.getc() - '0';
            pc.printf("%d", i);
            mySpeaker.trill(i);
        } else if (n == '4') {
            i = pc.getc() - '0';
            pc.printf("%d", i);
            mySpeaker.phone(i);
        } else if (n == '5') {
            i = pc.getc() - '0';
            pc.printf("%d", i);
            mySpeaker.bip(i);
            wait(1);
            mySpeaker.bop(i);
        } else if (n == '6') {
            i = pc.getc() - '0';
            pc.printf("%d", i);
            mySpeaker.bop(i);
            wait(1);
            mySpeaker.bop(i);
        } else if (n == '7') {
            i = pc.getc() - '0';
            pc.printf("%d", i);
            mySpeaker.beep(i);
        } else if (n == '8') {
            i = pc.getc() - '0';
            pc.printf("%d", i);
            mySpeaker.bleep(i);
        } else if (n =='9') {
            i = pc.getc() - '0';
            pc.printf("%d", i);
            mySpeaker.buzz(i);
        } else if (n == '=') {       //press = to stop a continuous sound
            mySpeaker.stop();
        } else if (n == 'm') {       //press m for SMB theme
            mySpeaker.play(smb);
        } else if (n == 'p') {       //press pn to play a tune in MML format
            i = pc.getc() - '0';
            pc.printf("%d", i);
            if (i == 0) {
                 n = mySpeaker.play(preset0);
            } else if (i == 1) {
                n = mySpeaker.play(preset1);
            } else if (i == 2) {
                n = mySpeaker.play(preset2);
            } else if (i == 3) {
                n = mySpeaker.play(preset3);
            } else if (i == 4) {
                n = mySpeaker.play(preset4, 0);
            } else if (i == 5) {
                n = mySpeaker.play(preset4, 1);
            } else if (i == 6) {
                n = mySpeaker.play(preset4, 2);
            } else if (i == 7) {
                n = mySpeaker.play(preset4, 3);
            }
            if (n > 0) {
            	pc.printf(" ??input error at char %d", n);
            }
        } else if (n == 'q') {		 //play quick tune
        	scanf("%39s", buf);
        	pc.printf("%s", buf);
        	n = mySpeaker.play(buf);
            if (n > 0) {
            	pc.printf(" ??input error at char %d", n);
            }
        } else if (n == 't') {       //press tn to set timbre
        	i = pc.getc() - '0';
            pc.printf("%d", i);
            mySpeaker.timbre(i);
        } else if (n == 'z') {       //press z to time tone() call
            t.reset();
            t.start();
            for (int i = 0; i < 1000000; i++) {
                mySpeaker.tone(440.0, 0.0);
            }
            t.stop();
            pc.printf("<1 millon calls took %f seconds>", t.read());
        } else {
            badArgs();            
        }
        pc.printf("\n");
    }   //end of while
}

void printHelps(void) {
    pc.printf("0     Two-tone (police siren) in background (press = to stop)\n");
    pc.printf("1x    Yay (success) x times\n");
    pc.printf("2x    Wah (failure) x times\n");
    pc.printf("3x    Trill x times (0 = continuous in background)\n");
    pc.printf("4x    Phone x times\n");
    pc.printf("5     Bip x times (0 = continuous in background)\n");
    pc.printf("6x    Bop x times (0 = continuous in background)\n");
    pc.printf("7x    Beep x times (0 = continuous in background)\n");
    pc.printf("8x    Bleep x times (0 = continuous in background)\n");
    pc.printf("9x    Buzz x times (0 = continuous in background)\n");
    pc.printf("=     Stop background sound or music\n");
    pc.printf("m     Super Mario Brothers theme\n");
    pc.printf("px    Play preset tune x in MML format (x = 0-7)\n");
    pc.printf("q abc Play quick tune as entered on the command line\n");
    pc.printf("tx    Set timbre (x = 1-4)\n");
}

//************************
// Miscellaneous functions
//************************

void badArgs(void) {
    pc.printf("?? Bad arguments\n");
}

void nyi(void) {
    pc.printf("!! Not yet implemented\n");
}

void pause(void)
{
    pc.printf("Press any key to continue . . .\n");
    pc.getc();
}

//END of main.cpp
