#include "mbed.h"
#include "rtwdemo_pmsmfoc.h"           /* Model's header file */
#include "rtwtypes.h"
#include "math_helper.h"

Timer timer1;

  /* '<Root>/pwm_compare' */
  static uint16_T pwm_compare[3];

  /* '<Root>/sensors' */
  static SENSORS_STRUCT sensors = {
    {
      0U, 0U }
    ,                                  /* adc_phase_currents */
    0U,                                /* encoder_valid */
    0U                                 /* encoder_counter */
  } ;
  
  
void rt_OneStep(void);
void rt_OneStep(void)
{
  static boolean_T OverrunFlag = false;

  /* '<Root>/motor_on' */
  static uint16_T motor_on = 1U;

  /* '<Root>/command_type' */
  static EnumCommandType command_type = Velocity;

  /* '<Root>/command_value' */
  static real32_T current_request = 0.0F;

  /* '<Root>/error' */
  static EnumErrorType error;

  /* Disable interrupts here */

  /* Check for overrun */
  if (OverrunFlag) {
    printf("------------------OVERRUN!!\r\n");
    return;
  }

  OverrunFlag = true;

  /* Save FPU context here (if necessary) */
  /* Re-enable timer or interrupt here */
  /* Set model inputs here */

  timer1.start();

  /* Step the model for base rate */
  error = Controller(motor_on, command_type, current_request, &sensors,
                     pwm_compare);

  timer1.stop();
  
  printf("exec us: %d err: %d\r\n",timer1.read_us(),error);
  timer1.reset();
  
  /* Get model outputs here */

  /* Indicate task complete */
  OverrunFlag = false;

  /* Disable interrupts here */
  /* Restore FPU context here (if necessary) */
  /* Enable interrupts here */
}


Serial pc(SERIAL_TX, SERIAL_RX);
 
DigitalOut myled(LED1);
 
int main() {
  
    /* Initialize model */
  Controller_Init();
  srand(time(NULL));
  int i = 1;
  pc.printf("PMSM Init done.\n");
  
  while(1) { 
      wait(0.5);
      sensors.adc_phase_currents[0] = rand()%MAX_uint16_T;
      sensors.adc_phase_currents[1] = rand()%MAX_uint16_T;
      printf("%d %d\r\n",sensors.adc_phase_currents[0],sensors.adc_phase_currents[1]);
      sensors.encoder_valid = 1;
      sensors.encoder_counter = i*20;

      rt_OneStep();
      
      pc.printf("%d: pwm0: %d vel: %f mode: %d\r\n", i++, pwm_compare[0], velocity_measured, controller_mode);
      myled = !myled;
      
      printf("arm: %f\r\n",arm_sin_f32(3.14159F/3));
  }
}
 