//*********************************************************************************************************************
//   LOGGER DEFINITIONS - HEADER FILE
//   PAUL HARRIS, OCTOBER 2016
// *********************************************************************************************************************

#ifndef LOGGER_DEFS_H
#define LOGGER_DEFS_H

enum eLogLevel{
    SUPPRESSED  = 0,
    ERROR       = 1,
    WARNING     = 2,
    NORMAL      = 3,
    DETAILED    = 4,
    VERBOSE     = 5
};

//Array of char pointers with name of log level enums for printing out (must match enums above)
static const char* sLogLevel[] = {
    "SUPPRESSED",
    "ERROR",
    "WARNING",
    "NORMAL",
    "DETAILED",
    "VERBOSE"
};

enum eLogArea{
    LOGGER          = 0, //Log area for the logger itself.  Required as an absolute minimum.
    MAIN            = 1,
    SYSTEM_CONTROL    = 2,
    LIDAR_IF        = 3,
    LIDAR_CONTROL   = 4,
    MOTOR_CONTROL   = 5,
    ENCODER         = 6,
    EVENT           = 7,
    OBSERVER        = 8
};

//Array of char pointers with name of log area enums for printing out (must match enums above)
static const char* sLogArea[] = {
    "LOGGER",
    "MAIN",
    "SYSTEM_CONTROL",
    "LIDAR_IF",
    "LIDAR_CONTROL",
    "MOTOR_CONTROL",
    "ENCODER",
    "EVENT",
    "OBSERVER"
};

#endif
