//*********************************************************************************************************************
//   LOGGER LIBRARY - HEADER FILE
//   PAUL HARRIS, OCTOBER 2016
// *********************************************************************************************************************

#ifndef LOGGER_H
#define LOGGER_H

#include "mbed.h"
#include <vector>
#include <stdio.h> 
#include <stdarg.h>

#include "logger_defs.h"
#include "MODSERIAL.h"


class cLogger{
    public:
        //***********Begin constructor************
        cLogger(MODSERIAL* std_out);
        //***********End constructor************
        
        //***********Begin Public member functions************
        
        //Registers a log area with the logger with specified default log level and prefix
        void registerLogArea(eLogArea area, eLogLevel defaultLevel, const char* log_prefix);
        //Log the specified formatted log text given the text's specified area and level (printf like formatting variable arguments)
        void log(eLogArea area, eLogLevel text_level, char* log_text, ...);
        //Log plain formatted text, bypassing any logger level control and without an area prefix (warning: will always be logged!)
        void plainText(char* log_text, ...);
        //Print a new line
        void newLine(void);
        //Set the specified log area level
        void setLogLevel(eLogArea area, eLogLevel level);
        //Set all log areas to the specified log level
        void setAllAreaLevels(eLogLevel level);
        //Set the specified log area text prefix
        void setLogPrefix(eLogArea area, const char* log_prefix);

        //***********End Public member functions************
        
    private:

        //***********Begin Private member functions************
        
        //Returns the index in the log_list of the given log area
        int getLogListIndex(eLogArea area);
        
        //Print formatted log text with its associated log level prefix
        void printf(eLogArea area, char* log_text, va_list args);
        
        //***********End Private member functions************
        
        
        //***********Begin Private member variables************
        
        //Pointer to the MODSERIAL object to use for log output
        MODSERIAL* pStdOut;
        
        //Mutex for making MODSERIAL printf thread safe
        Mutex stdio_mutex;
        
        //Structure to hold log areas and their associated levels/prefixes
        struct log_struct
        {
            eLogArea area;
            eLogLevel level;
            const char* prefix;
        };
    
        //Type def of log_struct structure
        typedef struct log_struct log_t;
        
        //Vector containers to hold vector of log area structures
        std::vector<log_t> log_list;
        
        //***********End Private member variables************

};
#endif