#ifndef _DisplayI2C_h_INCLUDE
#define _DisplayI2C_h_INCLUDE

#include "mbed.h"
/** The DisplayI2C class provides simplified access to a 4 digit 7 segment LED display
 *  over I2C via an MCP23017 port expander
 */
class DisplayI2C
{
public:
    /**
     *  @param[in] i2c  pass in a reference to the programs I2C instance.
     *  @param[in] address  I2C address of the MCP device (set by external resistors)
     *  @param[in] decimalpoint  set the digit to show a decimal point. If set
    *                            greater than 4 then no decimal point is enabled.
     */
    DisplayI2C(I2C& i2c, uint8_t address, uint8_t decimalpoint = 5);
    /**
     *  Call once to initialize the MCP device registers.
     */
    void Setup();
    /**
     *  Set the value to be displayed.
     *  @param[in] value  integer value (0 - 9999)
     */
    void SetValue(int value);
    /**
     *  Enable slow flashing of the whole display to indicate an alternate mode
     *  @param[in] flashing  true to enable flashing mode
     */
    void SetFlashing(bool flashing);
    /**
     *  This function must be called at intervals to multiplex to the next digit.
     *  Ideally the digits should be updated at 50Hz so this function should be
     *  called at 200Hz.
     */
    void Update();

private:
    void SetLEDs(uint8_t value);
    void SelectDigit(uint8_t digit);
    I2C & mI2C;
    uint8_t mAddr;
    uint8_t mDigit;
    uint8_t mDP; // Digit with decimal point (>4 to disable)
    bool mFlashing;
    char mValue[5];
};

#endif // _DisplayI2C_h_INCLUDE
