#include "DisplayI2C.h"

#define IOCON 0x0A
#define IODIRA 0x00
#define IODIRB 0x01
#define GPIOA 0x12
#define GPIOB 0x13

DisplayI2C::DisplayI2C(I2C& i2c, uint8_t address, uint8_t dp) :
    mI2C(i2c),
    mAddr(address),
    mDigit(0),
    mDP(dp)
{
    mValue[0] = 0;
    mValue[1] = 0;
    mValue[2] = 0;
    mValue[3] = 0;
    mValue[4] = 0;
}

void DisplayI2C::
Setup()
{
    char buffer[3];
    // Initialize the MCP device
    buffer[0] = IOCON; // IOCON.BANK = 0
    buffer[1] = 0;
    mI2C.write(mAddr, buffer, 2);
    buffer[0] = IODIRA;
    buffer[1] = 0; // port A as output
    buffer[2] = 0; // port B as output
    mI2C.write(mAddr, buffer, 3);
}

void DisplayI2C::
SetLEDs(uint8_t value)
{
    char buf[3];
    uint8_t x;
    // reversed
    switch (value) {
        case 0: x = 0xfc; break;
        case 1: x = 0x60; break;
        case 2: x = 0xda; break;
        case 3: x = 0xf2; break;
        case 4: x = 0x66; break;
        case 5: x = 0xb6; break;
        case 6: x = 0xbe; break;
        case 7: x = 0xe0; break;
        case 8: x = 0xfe; break;
        case 9: x = 0xf6; break;
        default: x = 0x0; break;
    }
    if (mDigit == mDP && x != 0)
        x |= 0x01;
    buf[0] = GPIOA;
    buf[1] = (char)x;
    mI2C.write(mAddr, buf, 2);
}

void DisplayI2C::
SelectDigit(uint8_t digit)
{
    char buf[2];
    buf[0] = GPIOB;
    buf[1] = digit;
    mI2C.write(mAddr, buf, 2);
}

void DisplayI2C::
Update()
{
    SetLEDs(0xff);                  // set all leds off
    SelectDigit(1<<mDigit);         // choose digit
    SetLEDs(mValue[mDigit] - 0x30); // select the digit led values
    mDigit = (mDigit + 1) % 4;      // next digit
}

void DisplayI2C::
SetValue(int value)
{
    mValue[3] = 0x30 + (value % 10);
    mValue[2] = 0x30 + ((value / 10) % 10);
    mValue[1] = 0x30 + ((value / 100) % 10);
    mValue[0] = 0x30 + ((value / 1000) % 10);
}
