
#ifndef __LSM303DLHC_H
#define __LSM303DLHC_H
#include "mbed.h"

    /* --- Mag --- */
#define CRA_REG_M 0x00
#define    CRB_REG_M    0x01
#define    MR_REG_M    0x02
#define    OUT_X_M     0x03
#define    OUT_Y_M     0x05
#define    OUT_Z_M     0x07
    /* --- Acc --- */
#define    CTRL_REG1_A  0x20
#define    CTRL_REG4_A 0x23
#define    OUT_X_A     0x28
#define    OUT_Y_A     0x2A
#define    OUT_Z_A     0x2C

class LSM303DLHC {
    public:
        /** Create a new interface for an LSM303DLHC
         *
         * @param sda is the pin for the I2C SDA line
         * @param scl is the pin for the I2C SCL line
         */
        LSM303DLHC(PinName sda, PinName scl);

  
        /** read the raw accelerometer and compass values
         *
         * @param ax,ay,az is the accelerometer 3d vector, written by the function
         * @param mx,my,mz is the magnetometer 3d vector, written by the function
         */
         bool readcomp(float *mx, float *my, float *mz);
         bool readacc(float *ax, float *ay, float *az);
         bool write_reg(int addr_i2c,int addr_reg, char v);

    private:
        I2C _LSM303;

         
        float ax, ay, az;
        float mx, my, mz;         
         
        
        bool read_reg(int addr_i2c,int addr_reg, char *v);
        bool recv(char sad, char sub, char *buf, int length);
};

#endif