#include "mbed.h"



/************************************************************************
* handles creating an sd card object, opening the .txt file
* then writes array c and closes file
************************************************************************/
void writeToSdCard()
{
    pc.printf("Begin write SD Card routine\r\n");
    mkdir("/sd/mydir", 0777);

    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    
    while(fp == NULL) 
    {
        error("Could not open file for write\r\n");
    }

    pc.printf("Start writing...");
    
    for (int i = 0; i < arrayCount; i++)
    {    
        fprintf(fp, "%f\r\n", squibCLT_array[i]);  
    }

    fclose(fp);         
    pc.printf("Done\r\n");
}



/************************************************************************
* handles opening the named .txt file and stores everything 
* to the char array c and then closes the file.
* 
* 
************************************************************************/
void readFromSdCard()
{
    pc.printf("Begin read SD Card routine\r\n");
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "r");
    
    while(fp == NULL) 
    {
        error("Could not open file for read\r\n");
    }
    
    pc.printf("Starting read...");
    
    for (int i = 0; i < arrayCount; i++)
    {
        fscanf(fp, "%f", &squibCLT_array2[i]);
    }           

    fclose(fp);


#if defined(__MICROLIB) && defined(__ARMCC_VERSION)                         // with microlib and ARM compiler  //possible sd card library bug.  Not sure if this helps
    free(fp);
#endif

    pc.printf("Done.\r\n");

}

