#include "mbed.h"






/************************************************************************
*  Copy tx line buffer to large tx buffer for tx interrupt routine      *
************************************************************************/
void send_line() 
{
    int i = 0;
    char temp_char;
    bool empty;

    __disable_irq();                                            //NVIC_DisableIRQ(UART1_IRQn);// Start Critical Section - don't interrupt while changing global buffer variables
    
    empty = (tx_in == tx_out);
    
    while ((i==0) || (tx_line[i-1] != '\n')) 
    {
        
        if (((tx_in + 1) % buffer_size) == tx_out)          // Wait if buffer full
        {        
            __enable_irq();                                  //NVIC_EnableIRQ(UART1_IRQn);// End Critical Section - need to let interrupt routine empty buffer by sending
            while (((tx_in + 1) % buffer_size) == tx_out) 
            {
            }
          
            __disable_irq();                                  //NVIC_DisableIRQ(UART1_IRQn);  // Start Critical Section - don't interrupt while changing global buffer variables
        }

        tx_buffer[tx_in] = tx_line[i];
//        if (tx_buffer[tx_in] == '\r'){pc.printf("returnline");}
        i++;
        tx_in = (tx_in + 1) % buffer_size;
    } 

    if (uart1.writeable() && (empty)) 
    {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % buffer_size;
        
        
        uart1.putc(temp_char);                                // Send first character to start tx interrupts, if stopped

//        pc.printf("send command. Value: %c\r\n", temp_char);
    }
    
    __enable_irq();                                              //NVIC_EnableIRQ(UART1_IRQn);  // End Critical Section
    return;
}
 
 
 
/************************************************************************
*  Read a line from the large rx buffer from rx interrupt routine       *
************************************************************************/
void read_line() 
{
    int i = 0;
    
    __disable_irq();                                        //NVIC_DisableIRQ(UART1_IRQn); // Start Critical Section - don't interrupt while changing global buffer variables
    while ((i==0) || (rx_line[i-1] != '\r'))                // Loop reading rx buffer characters until end of line character
    {
        if (rx_in == rx_out)                                // Wait if buffer empty
        {
            __enable_irq();                                 //NVIC_EnableIRQ(UART1_IRQn); // End Critical Section - need to allow rx interrupt to get new characters for buffer
            
            while (rx_in == rx_out) 
            {
            }
            __disable_irq();                                //NVIC_DisableIRQ(UART1_IRQn); // Start Critical Section - don't interrupt while changing global buffer variables
        }

        rx_line[i] = rx_buffer[rx_out];

        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }

    __enable_irq();                                         //NVIC_EnableIRQ(UART1_IRQn); // End Critical Section

    strcat(squibCLT_array3,rx_line);
    
    rx_line[i-1] = 0;
     
    return;
}
 
 

/************************************************************************
*  Interupt Routine to read in data from serial port                    *
************************************************************************/
void Rx_interrupt() 
{
            
    while ((uart2.readable()) && (((rx_in + 1) % buffer_size) != rx_out))    // Loop just in case more than one character is in UART's receive FIFO buffer
                                                                             // Stop if buffer full
    {
            rx_buffer[rx_in] = uart2.getc();
//          pc.putc(rx_buffer[rx_in]);                                              // Uncomment to Echo to USB serial to watch data flow
            rx_in = (rx_in + 1) % buffer_size;
            
    }
    
    rxInterruptCount++;
    return;
}
 
 

/************************************************************************
*  Interupt Routine to write out data to serial port                    *
************************************************************************/
void Tx_interrupt() 
{
    while ((uart1.writeable()) && (tx_in != tx_out))                        // Loop to fill more than one character in UART's transmit FIFO buffer      // Stop if buffer empty
    {

        uart1.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % buffer_size;
    }

    return;
}




/************************************************************************
* copies sd card array to serial buffer and sends it over buffer
*
************************************************************************/
void sendSdCardDataOverSerial()
{
    Timer timer;
    int begin, end;
    
    pc.printf("Sending over serial...");
    
    timer.start();
    begin = timer.read_us();
    
    for (int i = 0; i < arrayCount; i++)
    {
        sprintf(tx_line, "%.6f\r\n]", squibCLT_array2[i]);
        send_line(); 
    }

    end = timer.read_us();
    
    pc.printf("Done.\r\n");
    
    pc.printf("Transmit took %d microseconds to complete.\r\n", end - begin);
}



/************************************************************************
* handles receiving data and storing it back into local memory
*
************************************************************************/    
void receiveSdCardDataOverSerial()
{
    Timer timer;
    int begin, end;

    pc.printf("Receiving over serial...");
        
    timer.start();
    begin = timer.read_us();
    
    for (int i = 0; i < arrayCount; i++)
    {
// for some reason you have to use this function to read in everything being sent instead of relying on the interrupt service exclusively
        read_line();
        //sprintf(squib_test, "%s", rx_line);
    }
    end = timer.read_us();
    
    pc.printf("Done.\r\n");
    
    pc.printf("Receive took %d microseconds to complete.\r\n", end - begin);
}

