#include "mbed.h"
#include "SDFileSystem.h"
#include "globals.h"
#include <string>
#include <cstring>
#include "ReadADC.h"
#include "serial_transfer.h"
#include "sd_card.h"


/*========================================================================================
                                           NOTES
  ========================================================================================


6/14/2016 - Everything is working!  115200 baud with array sizes of 32 bytes seems to be
            what is working reliably.
          - Keeping array sizes at 32 seems easy to send and receive over serial.  Trying
            to figure out why serial receive hangs with more than 32 bytes of data
            

6/1/2016 - test to see if the recieve interrupt is handling the serial transfer and the
           read_line() does not need to be called
         - set up receive buffer to be stored into an array
           ... this will depend on where serial data is being received


Board:  STM Nucleo f303re
Serial communciation: 
    uart2 is connected to uart1 = 
    PC_10 to D2, PC_11 to D8
SPI communication to SD card:
    MOSI, MISO, SCK, CS
******************************************************************************************/





 


/*========================================================================================
                                              MAIN
  ========================================================================================*/


/************************************************************************
* main handles:
*       setting up serial ports, interrupts 
*       reading ADC data into char array c
*       then store it to an SD card, 
*       then send it over serial
*
************************************************************************/
int main() 
{
    pc.baud(128000);
// 6/1/2016 sped up baud rate and need to compare with output to see if still the same
// 6/14/2016 any baud rate over 115200 hangs up the serial recieve interrupt :/
    uart1.baud(115200);
    uart2.baud(115200); 
    uart1.attach(&Tx_interrupt, Serial::TxIrq);                                         // Setup a serial interrupt function to transmit data
    uart2.attach(&Rx_interrupt, Serial::RxIrq);                                         // Setup a serial interrupt function to receive data
    
    
    for (int j = 0; j < 10; j++)
    {
        pc.printf("\r\nStarting SD card and serial test.\r\n\r\n");   
  
        readADC();  
    
        writeToSdCard();
        readFromSdCard();

        sendSdCardDataOverSerial();
        receiveSdCardDataOverSerial();                                                    // Rx interrupt interferes with this since it reads from 2 places
    

    //debug code
        for(int i = 0; i < arrayCount; i++)
        {
            pc.printf("     %f  -   %f   \r\n", squibCLT_array[i], squibCLT_array2[i]);   //, squib_test);
        }
                
            pc.printf("%s", squibCLT_array3);
            pc.printf("\r\n\r\n");
        
    
        pc.printf("%d     %d\r\n", rxInterruptCount, sendCount);
    
        pc.printf("\r\nEND\r\n");
        cleanBuffers();
    }
}



