#include "mbed.h"



/*========================================================================================
                                  PROTOCOL SETUP/INSTANTIATE
  ========================================================================================

******************************************************************************************/
SDFileSystem sd(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, "sd"); // mosi,miso,sclk,cs,name
RawSerial pc(SERIAL_TX, SERIAL_RX);
RawSerial uart1(PC_12, PD_2); // tx, rx
RawSerial uart2(PC_10, PC_11); //tx, rx
AnalogIn squibCLT_ADC(A0);



/*========================================================================================
                                  GLOBAL VARIABLES
  ========================================================================================

******************************************************************************************/



//some global variables to pass data around


float squibCLT_array2[256];
char squibCLT_array3[256];

int ADCReadCount = 32;
int arrayCount = 0;
float squibCLT_array[256];

int sendCount, rxInterruptCount = 0;



//serial interrupts transfer variables
const int buffer_size = 255;
char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];
volatile int tx_in = 0;
volatile int tx_out = 0;
volatile int rx_in = 0;
volatile int rx_out = 0;
volatile int receiveBuffer = 0;
char tx_line[80];
char rx_line[80];






/*========================================================================================
                                 FUNCTION
  ========================================================================================

******************************************************************************************/


/************************************************************************
* clean all the buffers
************************************************************************/
void cleanBuffers()
{
    memset(tx_buffer, 0, sizeof(tx_buffer));
    memset(rx_buffer, 0, sizeof(rx_buffer));
    tx_in = 0;
    tx_out = 0;
    rx_in = 0;
    rx_out = 0;
    receiveBuffer = 0;
    memset(tx_line, 0, sizeof(tx_line));
    memset(rx_line, 0, sizeof(rx_line)); 
    arrayCount = 0;
    memset(squibCLT_array, 0, sizeof(squibCLT_array));
    memset(squibCLT_array3, 0, sizeof(squibCLT_array3));
    rxInterruptCount = 0;   
}

