#include "mbed.h"
#include "EthernetInterface.h"

#include <stdio.h>
#include <string.h>

#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1023
#define HTTPD_MAX_HDR_LENGTH   2056

#define LED_R 26
#define LED_G 22
#define LED_B 21


Serial uart(USBTX, USBRX);


EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;

char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];

char *uristr;
char *eou;
char *qrystr;


int rdCnt;

char *first = "/first";
char *sec = "/second";
char *led = "/led";
char *ledr = "/led/r";
char *ledg = "/led/g";
char *ledb = "/led/b";

DigitalOut ledR(LED1,1);
DigitalOut ledG(LED2,1);
DigitalOut ledB(LED3,1);

char led_stat = 0;
void show_page(char* uri)
{
    uart.printf("Trying to open requested uri\r\n");
    uart.printf("%s\r\n",uri);
    char *lstchr_ptr = strrchr(uri, NULL) -1; //function try to find char which is non ascii (recently set to 0 so no ascii)
    if(!strcmp(uri, first)){
        sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
        client.send(httpHeader,strlen(httpHeader));
        sprintf(httpHeader,"<html><head><title>First_one</title></head><body><h1>First page has been opened</h1></body></html>");
        client.send(httpHeader,strlen(httpHeader));
    }
    else if(!strcmp(uri, sec)){
        sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
        client.send(httpHeader,strlen(httpHeader));
        sprintf(httpHeader,"<html><head><title>Seond_one</title></head><body><h1>Second page has been opened</h1></body></html>");
        client.send(httpHeader,strlen(httpHeader));
    }
    else if(!strcmp(uri, led)){
        sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
        client.send(httpHeader,strlen(httpHeader));
        sprintf(httpHeader,"<html><head><title>LED</title></head><body> \n"
        "<button id='rb' onclick='hget(\"r\")'>RED</button><br/> \n"
        "<button id='gb' onclick='hget(\"g\")'>GREEN</button><br/> \n"
        "<button id='bb' onclick='hget(\"b\")'>BLUE</button><br/> \n"
        "<div id='ramka'>NAPIS</div><br/> \n"
        "</h1> \n"
        "</body>\n"
        "<script type='text/javascript'>\n"
        "function hget(val){ \n"
        " var x = new XMLHttpRequest(); \n"
        " x.onreadystatechange = function() { \n"
        " if (x.readyState == 4 && x.status == 200){ \n"
        " if(x.responseText=='r') document.body.style.backgroundColor='red';\n"
        " else if (x.responseText=='b') document.body.style.backgroundColor='blue';\n"
        " else if (x.responseText=='g') document.body.style.backgroundColor='green';\n"
        " else document.body.style.backgroundColor='white';}}\n"
        " x.open('GET', '/led/'+val, true);\n"
        " x.send(null);}\n"
        " </script>\n"
    "</html>");
        client.send(httpHeader,strlen(httpHeader));
    }
    else if(!strcmp(uri, ledr)){
        led_stat ^= 1;
        ledR.write(!(led_stat&1));
        if(led_stat & 1){
            client.send("r",1); //+zapalic led
        } else {
            client.send("w",1);
        }
        //uart.printf("RED\n");
    }
    else if(!strcmp(uri, ledg)){
        led_stat ^= 2;
        ledG.write(led_stat&2);
        if(!(led_stat & 2)){
            client.send("g",1); //+zapalic led
        } else {
            client.send("w",1);
        }
        //uart.printf("GREEN\n");
    }
    else if(!strcmp(uri, ledb)){
        led_stat ^= 4;
        ledB.write(!(led_stat&4));
        if(led_stat & 4){
            client.send("b",1); //+zapalic led
        } else {
            client.send("w",1);
        }
        //uart.printf("BLUE\n");
    }
    else{
        sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
        client.send(httpHeader,strlen(httpHeader));
        sprintf(httpHeader,"<html><head><title>ERROR</title></head><body><h1>THERE IS NO SUCH PAGE</h1></body></html>");
        client.send(httpHeader,strlen(httpHeader));
    }
}

int main (void)
{
    //ledR.write(1);
    //ledB.write(1);
//    Serial Interface eth;
    uart.baud(115200);
    uart.printf("Initializing\r\n");

//    EthernetInterface eth;
    uart.printf("Initializing Ethernet ...\r\n");
    if(!eth.init("192.168.5.10", "255.255.255.0", "192.168.5.50")){//Init interface with static IP
        uart.printf("Ethernet interface configured properly\r\n");
    }
    uart.printf("Setting interface UP ...\r\n");
    eth.connect();
    uart.printf("IP: %s\r\n", eth.getIPAddress());
    uart.printf("Mask: %s\r\n", eth.getNetworkMask());

//    TCPSocketServer server;
    uart.printf("Starting TCP server at port: %d\r\n", HTTPD_SERVER_PORT);
    server.bind(HTTPD_SERVER_PORT);
    server.listen();
    uart.printf("Server starts listening at port: %d\r\n", HTTPD_SERVER_PORT);

    while (true) {
        uart.printf("\nWaiting for new connection...\r\n");
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s

        uart.printf("Client with IP %s has connected with server.\r\n", client.get_address());
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            uart.printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,n,buffer);
            if (n >= 1024) {
                sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                client.send(buffer,n);
                break;
            } else {
                buffer[n]=0;
            }
            if (!strncmp(buffer, "GET ", 4)) {
                uristr = buffer + 4;
                eou = strstr(uristr, " ");
                if (eou == NULL) {
                    sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                    client.send(httpHeader,strlen(httpHeader));
                    client.send(buffer,n);
                } else {
                    *eou = 0;
                    show_page(uristr);
                }
            }
        }

        client.close();
    }
}
