#include "mbed.h"
#include "TextLCD.h"
#define btnRIGHT  0
#define btnUP     1
#define btnDOWN   2
#define btnLEFT   3
#define btnSELECT 4
#define btnNONE   5

Serial pc (SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);
AnalogIn analog_value(A0);
TextLCD lcd(D8,D9,D4,D5,D6,D7);

 float meas;
int read_LCD_buttons(){               
     meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        meas = meas * 3300; // Change the value to be in the 0 to 3300 range
        if (meas > 3300) return btnNONE; 
        if (meas < 50)   return btnRIGHT;  
        if ((meas > 900)&&( meas < 1300)) return btnUP; 
        if ((meas > 1800)&&( meas < 2200)) return btnDOWN; 
        if ((meas > 2800)&&( meas < 3200)) return btnLEFT; 
        return btnNONE;
    }
        
int main()
{
    int lcd_key;
    lcd.printf("NUCLEO F103RB");
    while(1) 
        {
         wait_ms(200);
         lcd_key = read_LCD_buttons();   // read the buttons
       switch (lcd_key){               // depending on which button was pushed, we perform an action
           case btnRIGHT:{             //  push button "RIGHT" and show the word on the screen
                lcd.locate(4,1);
                lcd.printf("RIGHT ");
           break;}
           case btnLEFT:{
             lcd.locate(4,1);
             lcd.printf("LEFT   "); //  push button "LEFT" and show the word on the screen
             break;}
          case btnUP:{
             lcd.locate(4,1);
             lcd.printf("UP    ");  //  push button "UP" and show the word on the screen
             break;}
         case btnDOWN:{
             lcd.locate(4,1);
             lcd.printf("DOWN  ");  //  push button "DOWN" and show the word on the screen
             break;}
         case btnSELECT:{
             lcd.locate(4,1);
             lcd.printf("SELECT");  //  push button "SELECT" and show the word on the screen
             break;}
        case btnNONE:{
             lcd.locate(4,1);
             lcd.printf("NONE  ");  //  No action  will show "None" on the screen
             break;}
       }
}
}



 