#include "mbed.h"
#include "eeprom_flash.h"
Serial pc(USBTX, USBRX); //Initalise PC serial comms
DigitalOut myled(LED1);
/*
 * Must call this first to enable writing
 */
void enableEEPROMWriting() {
    HAL_StatusTypeDef status = HAL_FLASH_Unlock();
    FLASH_PageErase(EEPROM_START_ADDRESS); // required to re-write
    CLEAR_BIT(FLASH->CR, FLASH_CR_PER);    // Bug fix: bit PER has been set in Flash_PageErase(), must clear it here
}

void disableEEPROMWriting() {
    HAL_FLASH_Lock();
}

/*
 * Writing functions
 * Must call enableEEPROMWriting() first
 */
HAL_StatusTypeDef writeEEPROMHalfWord(uint32_t address, uint16_t data) {
    HAL_StatusTypeDef status;
    address = address + EEPROM_START_ADDRESS;
    status = HAL_FLASH_Program(FLASH_TYPEPROGRAM_HALFWORD, address, data);
    return status;
}

/*
 * Reading functions
 */
uint16_t readEEPROMHalfWord(uint32_t address) {
    uint16_t val = 0;
    address = address + EEPROM_START_ADDRESS;
    val = *(__IO uint16_t*)address;
     return val;
}

//Programme de test

int main() {
int adresse = 0x00;
char donnee1 = 11;
char donnee2 = 22;
char donnee3 = 33;
int lecture;
pc.baud(9600);

/* Ecriture*/
enableEEPROMWriting(); //autorisation d'ecriture dans l'eeprom
writeEEPROMHalfWord(adresse, donnee1);
writeEEPROMHalfWord(adresse+2, donnee2);
writeEEPROMHalfWord(adresse+4, donnee3);
disableEEPROMWriting(); //Interdiction d'ecriture

 myled=!myled;
        wait(0.5);
        myled=!myled;
        wait(0.5);

/*lecture et affichage*/
lecture=readEEPROMHalfWord(adresse);
if (lecture==11)
    {
        myled=!myled;
        wait(0.5);
        myled=!myled;
        wait(0.5);
        myled=!myled;
        wait(0.5);
    }
pc.printf ("valeur lue: %d\n\r",lecture);
lecture=readEEPROMHalfWord(adresse+2);
pc.printf ("valeur lue: %d\n\r",lecture);
lecture=readEEPROMHalfWord(adresse+4);
pc.printf ("valeur lue: %d\n\r",lecture);
 while(1);
}