#include "mbed.h"
#include "mbed_genie.h"

//Prototype des routines d'interruption
void compt_secondes();

int chrono;       

//Déclaration de l'interruptions Ticker 
Ticker seconde_ticker;

/*************************************************************************************************
  Interruption générée automatiquement toutes les secondes pour décrémenter le compteur  **
*************************************************************************************************/
void compt_secondes()
  {
    chrono=chrono-1;
    genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x00, chrono);      //write to Leddigits0 the value of voltLED
    return;
    }
 
/************************
*  Programme principal  *
*************************/

int main()
{
    SetupGenie();
    genieWriteContrast(10); //set screen contrast to full brightness
//Initialisation de l'interruption "Ticker" toutes les secondes
    seconde_ticker.attach(&compt_secondes,1); //Appel de la fonction toutes les secondes.
    chrono=99;
    while(1) {
            if(chrono ==0)
                chrono=99;
            }
}