/* 4d systems touch screen display.

uses the mbed_genie library ported from the arduino
visie-genie library by Christian B

The display serial TX and RX pins are connected to pin PA_9
and pin PA_10 of the mbed

The reset pin is not connected as reset function is not implemented

For setting up the display in Visie-Genie

The display has an gauge meter object, a LED digits object, two buttons
and three static text objects.

The On and Off button has been set to report on change
The baud rate of the display is set to 115200 baud
*/
#include "mbed.h"
#include "mbed_genie.h"

DigitalOut myled(LED1);   //LED 1 for indication

int flag = 0;        //holds the "power status" of the voltmeter. flag = 0 means voltmeter is "off", flag = 1 means the voltmeter is "on".
float chrono;       //holds the digital voltage value to be sent to the angular meter

//Event handler for the 4d Systems display
void myGenieEventHandler(void)
{
    genieFrame Event;
    genieDequeueEvent(&Event);
    //event report from an object
    if(Event.reportObject.cmd == GENIE_REPORT_EVENT) {
        /*
        for example here we check if we received a message from 4dbuttons objects
        the index is the button number, refer to the 4dgenie project to know the index
        */
        if (Event.reportObject.object == GENIE_OBJ_4DBUTTON) {              // If the Reported Message was from a button
            if (Event.reportObject.index == 0) {
                //printf("Off Button pressed!\n\r");
                wait(0.2);
                flag=1;
            }
            if (Event.reportObject.index == 1) {
                //printf("On Button pressed!\n\r");
                wait(0.2);
                flag=0;
            }
        }
    }

    //Cmd from a reported object (happens when an object read is requested)
    // if(Event.reportObject.cmd == GENIE_REPORT_OBJ)
    // {
    // }
}

int main()

{
    SetupGenie();
    genieAttachEventHandler(&myGenieEventHandler);
    genieWriteContrast(10); //set screen contrast to full brightness
    chrono=99;
    
    while(1) {
 
        if (flag == 1) {
            //printf("Flag status: %d \r\n", flag);
            chrono=chrono-1;
            genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x00, chrono);      //write to Leddigits0 the value of voltLED
            genieWriteObject(GENIE_OBJ_GAUGE , 0x00, chrono); //write to Angularmeter0 the value of voltMeter*/
            wait (0.5);
        }

        else if(flag == 0){
            genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x00, 0);  
            genieWriteObject(GENIE_OBJ_GAUGE , 0x00, 0); //write to Angularmeter0 the value of voltMeter
            chrono=99;
            wait (0.5);
            }

    }

}