/* A port test of the arduino voltmeter example using the
4.3' PCT 4d systems touch screen display.

uses the mbed_genie library ported from the arduino
visie-genie library by Christian B

The display serial TX and RX pins are connected to pin 9
and pin 10 of the mbed

The reset pin is not connected as reset function is not implemented

Pin 15 of the mbed has a potentiometer wiper connected to it
The other connections of the potentiometer are connected to +3.3V
and 0V

For setting up the display in Visie-Genie

The display has an angular meter objecr, a LED digits object, two buttons
and three static text objects.

The program sends digital voltage readings to the LED digits and
angular meter of the display module.

The On and Off button has been set to report on change

The baud rate of the display is set to 115200 baud

*/

#include "mbed.h"
#include "mbed_genie.h"

DigitalOut myled(LED1);   //LED 1 for indication

AnalogIn voltReading(PC_0);  //Potentiometer wiper connected to pin 15

int flag = 0;        //holds the "power status" of the voltmeter. flag = 0 means voltmeter is "off", flag = 1 means the voltmeter is "on".
float voltMeter;       //holds the digital voltage value to be sent to the angular meter
float voltLED;         //holds the digital voltage value to be sent to the LED digits

//Event handler for the 4d Systems display
void myGenieEventHandler(void)
{
    genieFrame Event;
    genieDequeueEvent(&Event);
    //event report from an object
    if(Event.reportObject.cmd == GENIE_REPORT_EVENT) {
        /*
        for example here we check if we received a message from 4dbuttons objects
        the index is the button number, refer to the 4dgenie project to know the index
        */
        if (Event.reportObject.object == GENIE_OBJ_4DBUTTON) {              // If the Reported Message was from a button
            if (Event.reportObject.index == 0) {
                //printf("Off Button pressed!\n\r");
                wait(0.2);
                flag=1;
            }
            if (Event.reportObject.index == 1) {
                //printf("On Button pressed!\n\r");
                wait(0.2);
                flag=0;
            }
        }
    }

    //Cmd from a reported object (happens when an object read is requested)
    // if(Event.reportObject.cmd == GENIE_REPORT_OBJ)
    // {

    // }

}

int main()

{
    SetupGenie();
    genieAttachEventHandler(&myGenieEventHandler);
    //genieResetDisplay();

    printf("Langsters's mbed Visi-Genie Voltmeter demo \n\r");

    //genieWriteContrast(15); //set screen contrast to full brightness

             voltLED = 0.1;
    while(1) {
         printf("Test1\n\r");
        //voltLED = 0;

        if (flag == 1) {
            //printf("Flag status: %d \r\n", flag);
         /*   wait (0.1);
            voltLED = voltReading;
            wait (0.1);
            //printf("Volt bit Reading: %f \n\r",voltLED);
            voltLED = voltLED * 3.3;                                    //convert float reading to voltage
            //printf("voltLED: %f\r\n",voltLED);

           // voltLED = voltLED * 1000;
           voltLED = 2.2;
           printf("voltLED: %f\r\n",voltLED);
            genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x00, voltLED);      //write to Leddigits0 the value of voltLED
            //wait (0.1);
            wait (1);
            voltMeter = voltLED/100;
            genieWriteObject(GENIE_OBJ_ANGULAR_METER, 0x00, voltMeter); //write to Angularmeter0 the value of voltMeter*/
        }

        else if(flag == 0)

        {
            //printf("Flag status: %d \r\n", flag);
           /* wait (0.1);
            voltLED = 0;
            genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x00, 0);      //write to Leddigits0 the value of voltLED
            wait (0.1);

            //voltMeter = voltLED/100;
            genieWriteObject(GENIE_OBJ_ANGULAR_METER, 0x00, 0); //write to Angularmeter0 the value of voltMeter
            */
             voltLED = voltLED + 0.1;;
           printf("voltLED: %f\r\n",voltLED);
            genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x00, voltLED*100);  
            wait (0.5);
            genieWriteObject(GENIE_OBJ_ANGULAR_METER, 0x00, voltLED*20); //write to Angularmeter0 the value of voltMeter
        }

    }

}