#include "mbed.h"
#include "eeprom_flash.h"

//Prototype des routines d'interruption et fonctions
void Rx_interrupt_bluetooth();
void commande_mesure();
void commande_tir();
void tir();
void enableEEPROMWriting();
void disableEEPROMWriting();

//Configuration des liaisons série
Serial bluetooth(PC_10,PC_11);
Serial pc (SERIAL_TX,SERIAL_RX);

//Reset BT
DigitalOut reset_bluetooth(PC_12);

//Commandes des relais
DigitalOut SET1(PC_9);
DigitalOut RESET1(PC_8);
DigitalOut SET2(PC_6);
DigitalOut RESET2(PC_5);
DigitalOut SET3(PA_12);
DigitalOut RESET3(PA_11);
DigitalOut SET4(PB_11);
DigitalOut RESET4(PB_14);
DigitalOut SET5(PB_13);

//Entrée TIR
InterruptIn entree_tir(PB_9);

//Entrées convertisseurs
AnalogIn MESURE1(PC_2);
AnalogIn MESURE2(PC_3);
AnalogIn MESURE3(PC_1);
AnalogIn MESURE4(PC_0);

//carte F103
DigitalOut myled(LED1);

//Déclaration de l'interruptions Ticker 
Ticker capt_ticker;

//Déclaration des variables
int i,indic_delais,indic_mesure,indic_tir;
int delais1,delais2,delais3,delais4;
int adresse = 0x00;
char Trame_envoie[40];
char tempo1[4];
char tempo2[4];
char tempo3[4];
char tempo4[4];
int ib=0,jb=0;
char Trame_recue[30];

/*************************************************************
              Programme principal                           **
**************************************************************/
int main()
{
//reset du module bluetooth
reset_bluetooth=0;
wait(0.5);
reset_bluetooth=1;

//Positionnement du relais 1
SET1=0;
RESET1=1;
wait(0.2);
RESET1=0;
//Positionnement du relais 2
SET2=0;
RESET2=1;
wait(0.2);
RESET2=0;
//Positionnement du relais 3
SET3=0;
RESET3=1;
wait(0.2);
RESET3=0;
//Positionnement du relais 4
SET4=0;
RESET4=1;
wait(0.2);
RESET4=0;

SET5=0;


//Initialisation de l'interruption "front descendant sur l'entrée TIR"
entree_tir.fall(&commande_tir);
bluetooth.attach(&Rx_interrupt_bluetooth, Serial::RxIrq);

//Lecture des delais memorises
delais1=readEEPROMHalfWord(adresse);
delais2=readEEPROMHalfWord(adresse+2);
delais3=readEEPROMHalfWord(adresse+4);
delais4=readEEPROMHalfWord(adresse+6);

// On attend
while(1)
    {pc.printf("attente\r\n");
    
//on a recu la commande de lecture des resultats de mesure      
       if (indic_mesure ==1)
        {
        indic_mesure=0;
        commande_mesure();
        }
        
//on a recu la commande de configuration des tempo        
       if (indic_delais==1)
        {
        indic_delais=0;
        pc.printf("delais 1: %d ms\n\r",delais1);
        pc.printf("delais 2: %d ms\n\r",delais2);
        pc.printf("delais 3: %d ms\n\r",delais3);
        pc.printf("delais 4: %d ms\n\r",delais4);
//sauvegarde des delais       
        enableEEPROMWriting(); //autorisation d'ecriture dans l'eeprom
        writeEEPROMHalfWord(adresse, delais1);
        writeEEPROMHalfWord(adresse+2, delais2);
        writeEEPROMHalfWord(adresse+4, delais3);
        writeEEPROMHalfWord(adresse+6, delais4);
        adresse = 0x00;
        disableEEPROMWriting(); //Interdiction d'ecriture
        }
        
//on a recu la commande de tir           
       if (indic_tir==1)
        {
        indic_tir=0;
        pc.printf("indic_tir\n\r");
        tir();
        }
        
    myled=!myled;
    wait(0.5);
     }
 }
 
 void enableEEPROMWriting() {
    HAL_StatusTypeDef status = HAL_FLASH_Unlock();
    FLASH_PageErase(EEPROM_START_ADDRESS); // required to re-write
    CLEAR_BIT(FLASH->CR, FLASH_CR_PER);    // Bug fix: bit PER has been set in Flash_PageErase(), must clear it here
}

void disableEEPROMWriting() {
    HAL_FLASH_Lock();
}

/*
 * Writing functions
 * Must call enableEEPROMWriting() first
 */
HAL_StatusTypeDef writeEEPROMHalfWord(uint32_t address, uint16_t data) {
    HAL_StatusTypeDef status;
    address = address + EEPROM_START_ADDRESS;
    status = HAL_FLASH_Program(FLASH_TYPEPROGRAM_HALFWORD, address, data);
    return status;
}

/*
 * Reading functions
 */
uint16_t readEEPROMHalfWord(uint32_t address) {
    uint16_t val = 0;
    address = address + EEPROM_START_ADDRESS;
    val = *(__IO uint16_t*)address;
     return val;
}
 
  /********************************
*     Mesure de resistances    **
********************************/
void commande_mesure()
  {
 float meas1,meas2,meas3,meas4;
 //Mesure de la resistance 1
  SET5=1;
  wait(0.5);
  meas1=MESURE1.read();
  meas1 = meas1 * 12.17; // Change the value to be in the 0 to 3300 range
  pc.printf("resistance 1 = %.1f Ohms\r\n", meas1);
   
//Mesure de la resistance 2
  meas2=MESURE2.read();
  meas2 = meas2 * 11.87; // Change the value to be in the 0 to 3300 range
  pc.printf("resistance 2 = %.1f Ohms\r\n", meas2);
 
  //Mesure de la resistance 3
  wait(0.2);
  meas3=MESURE3.read();
  meas3 = meas3 * 11.89; // Change the value to be in the 0 to 3300 range
  pc.printf("resistance 3 = %.1f Ohms\r\n", meas3);
  
//Mesure de la resistance 4
  meas4=MESURE4.read();
  meas4 = meas4 * 12; // Change the value to be in the 0 to 3300 range
  pc.printf("resistance 4 = %.1f Ohms\r\n", meas4);
 //bluetooth.printf("ligne 1: %.1f Ohms\n\rligne 2: %.1f Ohms\n\rligne 3: %.1f Ohms\n\rligne 4: %.1f Ohms\n\r",meas1,meas2,meas3,meas4);
  bluetooth.printf(",%.1f,%.1f,%.1f,%.1f",meas1,meas2,meas3,meas4);
  SET5=0;
}                             
   
    
/*************************************************************
  Interruption permettant de débuter la séquence de tir           **
**************************************************************/
void commande_tir()
{
wait(0.1);
pc.printf("Commande tir\n\r");
indic_tir=1;
return;  
}


/*********************************************************************************************
  Routine d'interruption lancée lors d'une réception sur la liaison série connectée au bluetooth **
*********************************************************************************************/   
void Rx_interrupt_bluetooth()
{ 
//on désactive les interruption serie bluetooth
 bluetooth.attach(NULL, Serial::RxIrq);
 
//on teste le début de trame et on sauvegarde
if (bluetooth.getc()=='$')
    { 
    // on ecrit une valeur différente de 't' et 'd'
     Trame_recue[0]='z';
     ib=0;
    //On sauvegarde la trame jusqu'a deux caractères après '*' (pour le cheksum)
       while (Trame_recue[ib-3]!='*')
             {
            Trame_recue[ib]=bluetooth.getc();
            ib++;
              }
       if (Trame_recue[0]=='t') 
        {
            ib=2;
            // Tempo1
            while (Trame_recue[ib]!=',') 
                        {   
                         delais1=5*(Trame_recue[ib]);
                         ib++;
                          }
            ib++;
                       
            // Tempo2
            while (Trame_recue[ib]!=',') 
                        {   
                        delais2=5*(Trame_recue[ib]);
                        ib++;
                        }  
              ib++;
               
             // Tempo3       
             while (Trame_recue[ib]!=',') 
                        {   
                        delais3=5*(Trame_recue[ib]);
                        ib++;
                        }  
              ib++;
                 
              // Tempo4      
             while (Trame_recue[ib]!='*') 
                        {   
                        delais4=5*(Trame_recue[ib]);
                        ib++;
                        }  
             indic_delais=1; 
             }
             
         if (Trame_recue[0]=='d') 
                 {
                  indic_mesure =1;   
                 }
         }     
    
//on réactive les interruptions serie bluetooth
bluetooth.attach(&Rx_interrupt_bluetooth, Serial::RxIrq);
 return;   
}


/*************************************************************************************************
  commande des relais pour les tirs **
*************************************************************************************************/
void tir()
  {
  SET1=1;
  SET5=1;
  wait(0.1);
  SET5=0;
  SET1=0;
  wait(0.1);
  RESET1 =1;
  wait(0.1);
  RESET1=0;
  //pc.printf("delais1 %0.1f\n\r",delais1);
  wait_ms(delais1);
  
//Commande de l'inflammateur 2
 //pc.printf("Commande tir2\n\r");
  SET2=1;
  SET5=1;
  wait(0.1);
  SET5=0;
  SET2=0;
  wait(0.1);
  RESET2=1;
  wait(0.1);
  RESET2=0;
  wait_ms(delais2); 
    
 //Commande de l'inflammateur 3
  //pc.printf("Commande tir3\n\r");
  SET3=1;
  SET5=1;
  wait(0.1);
  SET5=0;
  SET3=0;
  wait(0.1);
  RESET3=1;
  wait(0.1);
  RESET3=0;
  wait_ms(delais3);
   
//Commande de l'inflammateur 4
// pc.printf("Commande tir4\n\r");
  SET4=1;
  SET5=1;
  wait(0.1);
  SET5=0;
  SET4=0;
 wait(0.1);
  RESET4=1;
  wait(0.1);
  RESET4=0;
  wait_ms(delais4);
  }                             