#include "mbed.h"
#include "mbed_genie.h"
#include "SDFileSystem.h"
#include "eeprom_flash.h"
SDFileSystem sd(D11, D12, D13, D10, "sd"); // the pinout on the mbed Cool Components workshop board
AnalogIn TensionBatterie(A1);
DigitalOut DELVERTE (PB_2);
DigitalOut DELORANGE (PB_1);
DigitalOut DELROUGE (PB_15,1); 
InterruptIn BOUTONPAUSE(USER_BUTTON);
//Prototype des routines d'interruption
void compt_secondes();
void valeur_volt();
int temps_global_secondes, temps_global_minutes, temps_global_heures, numero_tir1 = 1, numero_tir2 = 0, numero_tir_depart = 1, pause = 0,bloqueur, kchrono = 0,locker =0;
int i = 15, j_tir = 0;
int adresse = 0x00;
char donnee1 = 11;
char donnee2 = 22;
char donnee3 = 33;
float valeur_tension, valeur_analogique;  // Permet d'avoir des mesures precises pour la tension    
    char cMonText[1024];
    char cMonText2[1024];
    char chiffre1[6];
    char chrono[40];
    char i1=0;
    char j=0;
    char k=0;
    int val1;
    char chiffre2[6];
    char type_tir[40];
    char i2=0;
    char j2=0;
    char k2=0;
    int val2;
//Déclaration des interruptions Ticker 
Ticker Horloge_Global_Seconde;
Ticker Valeur_Tension_Volt;
/*************************************************************************************************
  Interruption générée automatiquement toutes les secondes pour décrémenter le compteur  **
*************************************************************************************************/   
//Must call this first to enable writing
void enableEEPROMWriting() {
    HAL_StatusTypeDef status = HAL_FLASH_Unlock();
    FLASH_PageErase(EEPROM_START_ADDRESS); // required to re-write
    CLEAR_BIT(FLASH->CR, FLASH_CR_PER);    // Bug fix: bit PER has been set in Flash_PageErase(), must clear it here
}
void disableEEPROMWriting() {
    HAL_FLASH_Lock();
}
//Writing function
//Must call enableEEPROMWriting() first
HAL_StatusTypeDef writeEEPROMHalfWord(uint32_t address, uint16_t data) {
    HAL_StatusTypeDef status;
    address = address + EEPROM_START_ADDRESS;
    status = HAL_FLASH_Program(FLASH_TYPEPROGRAM_HALFWORD, address, data);
    return status;
}
//Reading functions
uint16_t readEEPROMHalfWord(uint32_t address) {
    uint16_t val = 0;
    address = address + EEPROM_START_ADDRESS;
    val = *(__IO uint16_t*)address;
     return val;
}

void vidReadText(char * cTxt)
{
    unsigned char caractereActuel;  // Début lecture SD
    int iIndex=0;
    FILE *fp = fopen("/sd/Temps.txt", "r");
    if(fp == NULL) 
    {
        error("Could not open file \n");
    }
    else
    {
         // Boucle de lecture des caractères un à un
         strcpy(cTxt,"");
         printf("\n\r");
           do{
                 caractereActuel = fgetc(fp); // On lit le caractère
                 if(caractereActuel != 255) sprintf(cTxt,"%s%c",cTxt, caractereActuel); // On l'affiche
                 iIndex++;
            }    while (caractereActuel != 255);
            fclose(fp); 
    } // Fin lecture SD
}

void vidReadText2(char * cTxt2)
{
    unsigned char caractereActuel2;  // Début lecture SD 2
    int iIndex2=0;
    FILE *fp = fopen("/sd/Ordre.txt", "r");
    if(fp == NULL) 
    {
        error("Could not open file \n");
    }
    else
    {
         // Boucle de lecture des caractères un à un
         strcpy(cTxt2,"");
         printf("\n\r");
           do{
                 caractereActuel2 = fgetc(fp); // On lit le caractère
                 if(caractereActuel2 != 255) sprintf(cTxt2,"%s%c",cTxt2, caractereActuel2); // On l'affiche
                 iIndex2++;
            }    while (caractereActuel2 != 255);
            fclose(fp); 
    } // Fin lecture SD 2
}


 void compt_secondes() //-------------------------------- Compteur seconde ----------------------------------------
  {
    if(bloqueur == 0) // Début bloqueur
    {
    chrono[kchrono]=chrono[kchrono]-1;
    genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x00, chrono[kchrono]);      //Ecrit sur Leddigits0 la valeur de chrono
    genieWriteObject(GENIE_OBJ_GAUGE , 0x00, chrono[kchrono]);
    temps_global_secondes = temps_global_secondes + 1;
    genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x01, temps_global_secondes);
        if(temps_global_secondes == 60){
                temps_global_secondes = 0;
                temps_global_minutes = temps_global_minutes + 1;
                genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x02, temps_global_minutes);
                    if(temps_global_minutes == 60)
                    {
                    temps_global_minutes = 0;
                    temps_global_heures = temps_global_heures + 1;
                    genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x03, temps_global_heures);
                    }
    }
    
    if (numero_tir_depart == 1){ // Début décompte
        genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x04, numero_tir1);
        temps_global_secondes= 0;
        genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x02, temps_global_secondes);
        temps_global_minutes = 0;
        genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x02, temps_global_minutes);
        temps_global_heures = 0;
        genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x02, temps_global_heures);
        numero_tir_depart++;
        genieWriteObject(GENIE_OBJ_USER_LED, 0x00, 0);
        }
    if(chrono[kchrono] == 0){
                
                if (type_tir[j_tir+1] == 0) // Tir normale
                {
                    numero_tir1++;
                    genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x04, numero_tir1);
                    genieWriteObject(GENIE_OBJ_USER_LED, 0x00, 0);
                }
                
                if (type_tir[j_tir+1] == 1) // Tir distance
                {
                    numero_tir2++;
                    genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x04, numero_tir2);
                    genieWriteObject(GENIE_OBJ_USER_LED, 0x00, 1);
                }             
                
                j_tir++;
                chrono[kchrono] = chrono[kchrono+1];
                kchrono++;
            } // Fin partie décompte seconde
    } // Fin bloqueur           
    genieFrame Event;
    genieDequeueEvent(&Event);
    //event report from an object
    if(Event.reportObject.cmd == GENIE_REPORT_EVENT) {
        /*
        for example here we check if we received a message from 4dbuttons objects
        the index is the button number, refer to the 4dgenie project to know the index
        */
        if (Event.reportObject.object == GENIE_OBJ_4DBUTTON) {              // If the Reported Message was from a button
            if (Event.reportObject.index == 9) { // Début Enclenchement bouton 9
                if (i<15)
                {
                i++;
                }
                genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x05, i);
                genieWriteContrast(i);
            } // Fin Enclenchement bouton 9
            if (Event.reportObject.index == 10) { // Début Enclenchement bouton 10
                if (i>0)
                {
                i--;
                }
                genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x05, i);
                genieWriteContrast(i);
            } // Fin Enclenchement bouton 10
            if (Event.reportObject.index == 15) { // Début Enclenchement bouton 15
            vidReadText(cMonText);
            vidReadText2(cMonText2);
            i1=0;
            k=0;
            i2=0;
            k2=0;
       
    while(cMonText[i1]!='*')
        {
            while(cMonText[i1]!=',')
                {
                    chiffre1[j]=cMonText[i1];
                    i1++;
                    j++;
                }
            val1 = atoi(chiffre1);
            chrono[k]=val1;
            j=0;
            i1++;
            k++;
        }
i1=0;
k=0;

    while(cMonText2[i2]!='*')
        {
            while(cMonText2[i2]!=',')
                {
                    chiffre2[j2]=cMonText2[i2];
                    i2++;
                    j2++;
                }
            val2 = atoi(chiffre2);
            type_tir[k2]=val2;
            j2=0;
            i2++;
            k2++;
        }
i2=0;
k2=0;
            } // Fin Enclenchement bouton 15
            
        }    
        }  
    return;
    }    
    
void valeur_volt() // ---------------------------------------------- Lecteur Tension ------------------------
  {
    valeur_analogique = TensionBatterie.read(); // Convertis la valeur obtenus entre 0 et 1
    valeur_tension = valeur_analogique * 6; // On multiplie notre valeur obtenus pour avoir la tension d entree
    genieWriteObject(GENIE_OBJ_METER , 0x00,valeur_tension);
    return;
    }

void pause1()
    {
    if(pause == 0)
        {
            pause++;
        }
    else
        {
            pause--;
        }
    }

/************************
*  Programme principal  *
*************************/

int main()
{
    
    wait(3);
    DELROUGE = 0;
    
    /* Ecriture*/
enableEEPROMWriting(); //autorisation d'ecriture dans l'eeprom
writeEEPROMHalfWord(adresse, donnee1);
writeEEPROMHalfWord(adresse+2, donnee2);
writeEEPROMHalfWord(adresse+4, donnee3);
disableEEPROMWriting(); //Interdiction d'ecriture
   
    SetupGenie();
    genieWriteContrast(i); //Permet de modifier la luminosite
    genieWriteObject(GENIE_OBJ_LED_DIGITS, 0x05, i);
    BOUTONPAUSE.fall(&pause1);
//Initialisation de l'interruption "Ticker" toutes les secondes 
    Horloge_Global_Seconde.attach(&compt_secondes,1); //Appel de la fonction toutes les secondes.
    Valeur_Tension_Volt.attach(&valeur_volt,30);

    while(1) {
            if(pause == 0)
            {
                DELVERTE = 0;
                DELORANGE = 1;
                bloqueur = 1;
            }        
            if(pause == 1)
            {
                DELVERTE = 1;
                DELORANGE = 0;
                bloqueur = 0;
            }           
             } // Fin while
} // Fin main