#include "mbed.h"
#include "SeeedStudioTFTv2.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

#define PIN_XP          A3
#define PIN_XM          A1
#define PIN_YP          A2
#define PIN_YM          A0
#define PIN_MOSI        D11
#define PIN_MISO        D12
#define PIN_SCLK        D13
#define PIN_CS_TFT      D5
#define PIN_DC_TFT      D6
#define PIN_BL_TFT      D7
#define PIN_CS_SD       D4

SeeedStudioTFTv2 TFT(PIN_XP, PIN_XM, PIN_YP, PIN_YM, PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_DC_TFT, PIN_BL_TFT, PIN_CS_SD);

int main()
{
    int Xperso,Yperso;
    point p;
    //Configure the display driver
    TFT.background(Black);
    TFT.foreground(White);
    TFT.set_font((unsigned char*) Arial24x23);
    while(1)
        {
         TFT.cls();
         TFT.fillrect(190,15,230,55,Blue);
         TFT.fillrect(150,250,230,295,Green);
         TFT.fillcircle(30,280,25,Red);
         wait(1.0);
         while (TFT.getTouch(p) != 1);
         TFT.locate(0,20);
         TFT.printf("x1: %6i",p.x);
         TFT.locate(0,50);
         TFT.printf("y1: %6i",p.y);
         TFT.locate(0,110);
         Xperso =((p.x/1000)-15);
         TFT.printf("x2: %6i",Xperso);
         TFT.locate(0,130);
         Yperso = ((p.y/1000)-21);
         TFT.printf("y2: %6i",Yperso);
        
        if ((Xperso < 8)&& (Yperso >70))
            {
             TFT.locate(0,200);
             TFT.printf("Carre");
            }
        if ((Xperso > 80)&& (Yperso >70))
            {
             TFT.locate(0,200);
             TFT.printf("Rectangle");
            }
        if ((Xperso > 80)&& (Yperso <12))
            {
            TFT.locate(0,200);
            TFT.printf("Rond");
            }     
        wait(2.0);
        }
}
