#include "mbed.h"

Serial pc(USBTX,USBRX);     // Tx, Rx Pin, default boud = 9600
I2C i2c(p28, p27);          // SDA, SCL

int main() 
{
    char cmd[2];            // Command
    char echo[2];           // Echo result data (8bit)
    int  addr  = 0xE0;      // Defalut I2C address of SRF08
    int  range = 0;         // Rage data (16bit, cm)
    
    cmd[0] = 0x02;          // Register(RangeValue)
    cmd[1] = 0x45;          // (RangeValue*43)+43 = (69*43)+43 = 3010mm, maximum range
    i2c.write(addr,cmd,2);  // Send I2C data (8bit*2)

    while(1) 
    {
        cmd[0] = 0x00;          // Register(Command)
        cmd[1] = 0x51;          // Ranging mode - Result in centimeters
        i2c.write(addr,cmd,2);  // Send I2C data (8bit*2)
        
        wait(0.07);             // Wait 70ms
        
        cmd[0] = 0x02;          // Register(1st Echo)
        i2c.write(addr,cmd,1);  // Send I2C data (8bit*1)
        i2c.read(addr,echo,2);  // Read I2C data (8bit*2)
        
        range = (echo[0]<<8)+echo[1];   // 8bit+8bit=16bit
    
        pc.printf("Range : %d cm\n",range);
    }
}

