/*
Copyright (c) 2011 JKSOFT

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "USBHost.h"
#include "Utils.h"
#include "Wiimote.h"
#include "motordriver.h"

AnalogIn L_IR1(p15);      // Analog In Pin
AnalogIn L_IR2(p16);      // Analog In Pin
AnalogIn L_IR3(p17);      // Analog In Pin
AnalogIn R_IR3(p18);      // Analog In Pin
AnalogIn R_IR2(p19);      // Analog In Pin
AnalogIn R_IR1(p20);      // Analog In Pin

DigitalOut LLED(p7);   // Digital Out Pin
DigitalOut RLED(p8);

DigitalOut L_IRLED1(p9);    // Digital Out Pin
DigitalOut L_IRLED2(p10);   // Digital Out Pin
DigitalOut L_IRLED3(p11);   // Digital Out Pin
DigitalOut R_IRLED3(p12);   // Digital Out Pin
DigitalOut R_IRLED2(p13);   // Digital Out Pin
DigitalOut R_IRLED1(p14);   // Digital Out Pin

Motor L_Motor(p25, p22, p21, 1); // pwm, fwd, rev, can break
Motor R_Motor(p26, p24, p23, 1); // pwm, fwd, rev, can break


// Direct control mode
int DirectMode( Wiimote* wii, int stat )
{
    LLED=1; 
    RLED=1; // LED Init    
    
    int ret = stat;
    
    if( wii->left )
    {
        L_Motor.speed(-1.0);
        R_Motor.speed(1.0);
        LLED = 1; RLED = 0;  
    }
    else if( wii->right )
    {
        L_Motor.speed(1.0);
        R_Motor.speed(-1.0);
        LLED = 0; RLED = 1;
    }    
    else if( wii->up )
    {
        L_Motor.speed(1.0);
        R_Motor.speed(1.0);
        LLED = 1; RLED = 1;  
    }
    else if( wii->down )
    {
        L_Motor.speed(-1.0);
        R_Motor.speed(-1.0);
        LLED = 0; RLED = 0;  
    }
    else
    {
        L_Motor.stop(0);
        R_Motor.stop(0);
    }

    float factor = wii->wheel / 150.0f; 
    
    float left_factor = (factor >= 0.0) ? 1.0 : 1.0 - (-factor);
    float right_factor = (factor <= 0.0) ? 1.0 : 1.0 - factor;
    
    if( wii->one )
    {
        L_Motor.speed(left_factor);
        R_Motor.speed(right_factor);
    }
    if( wii->two )
    {
        L_Motor.speed(-right_factor);
        R_Motor.speed(-left_factor);
    }
    
    return(ret);
}

// Processing when receiving it from Wiiremote
int wall_bot_remote(char *c,int stat)
{
    Wiimote wii;
    int ret = stat;
    
    wii.decode(c);
    
    ret = DirectMode( &wii ,ret );
    
    return(ret);
}

int GetConsoleChar()
{
    return(0);
}

int OnDiskInsert(int device)
{
    return(0);
}

int main()
{
    // USB Init is done for Bluetooth
    USBInit();
    
    while(1)
    {
       // USB Processing is done for Bluetooth
       USBLoop();
    }
}
