#include "mbed.h"
#include "herkulex.h"

// set serial port and baudrate, (mbed <-> HerculexX)
Herkulex sv(p9, p10, 115200);

int main() 
{   
    sv.clear(0xFD);
    
    sv.setTorque(0xFD, TORQUE_ON);
    
    sv.getStatus(0xFD);
    
    sv.getPos(0xFD);
   
    while(1) 
    {   
        // POS Mode, +159.8 Degree, 100*11.2ms = 1120ms, Green LED On
        sv.positionControl(0xFD, 1002, 100, GLED_ON);
        wait(5);
        
        // POS Mode, -159.8 Degree, 100*11.2ms = 1120ms, Blue LED On
        sv.positionControl(0xFD, 21, 100, BLED_ON);
        wait(5);

        // TURN Mode, CCW Turn, Green LED On
        sv.velocityControl(0xFD, 1023, GLED_ON);
        wait(5);
        
        // TURN Mode, CW Turn, Blue LED On        
        sv.velocityControl(0xFD, -1023, BLED_ON);
        wait(5);
        
        // POS Mode, 0 Degree, 100*11.2ms = 1120ms, Red LED On
        sv.positionControl(0xFD, 512, 100, RLED_ON);
        wait(5);
        
        // Clear error status
        sv.clear(0xFD);
    }
}
