#include <mbed.h>

#include <iostream>
#include <complex>
#include <cmath>

#define MAX 256
#define M_PI 3.1415926535897932384


Serial pc(USBTX, USBRX);
using namespace std;


float s;
float a = 1.0; //amplitude
float pi = 3.142; //pi
float o = 1; //offset
float time_count = 0.0;

int i = 0; //iteration counter
int f1 = 100; //frequency in Hz

float step = 1.0/(10.0*f1);

float* generateTimeVector (int vecSize, float stepSize)
{
//    pc.printf("\nGenerating Time Vector...\n");
    float *timeVec = new float[vecSize];
    for(int i=1; i<=vecSize; i++)
    {
        timeVec[i] = i*stepSize;
//        pc.printf("%f\n",timeVec[i]);
    }
    return timeVec;  
}

float* generateFreqVector(int vecSize, float stepSize)
{
//    pc.printf("\nGenerating Frequency Vector...\n");
    float *freqVec = new float[vecSize];
    float v = vecSize;
    for(int i=1; i<=(vecSize); i++)
    {
        freqVec[i] = (1.0/stepSize)*(i/v);
//        pc.printf("%f\n",freqVec[i]);
    }
    return freqVec;  
}

bool set1 = false;
bool set2 = false;
bool set3 = false;

void sineGenerate(complex<double>* sineVector, int index, float time, int freqHz, int amplitude, int offset)
{
       sineVector[index] = offset + amplitude*sin((2*pi) * freqHz * time);
//       pc.printf("%d, %f\n", index, sineVector[index]);
}
int log2(int N)    /*function to calculate the log2(.) of int numbers*/
{
  int k = N, i = 0;
  while(k) {
    k >>= 1;
    i++;
  }
  return i - 1;
}

int check(int n)    //checking if the number of element is a power of 2
{
  return n > 0 && (n & (n - 1)) == 0;
}

int reverse(int N, int n)    //calculating revers number
{
  int j, p = 0;
  for(j = 1; j <= log2(N); j++) {
    if(n & (1 << (log2(N) - j)))
      p |= 1 << (j - 1);
  }
  return p;
}

void ordina(complex<double>* f1, int N) //using the reverse order in the array
{
  complex<double> f2[MAX];
  for(int i = 0; i < N; i++)
    f2[i] = f1[reverse(N, i)];
  for(int j = 0; j < N; j++)
    f1[j] = f2[j];
}

void transform(complex<double>* f, int N) //
{
  ordina(f, N);    //first: reverse order
  complex<double> *W;
  W = (complex<double> *)malloc(N / 2 * sizeof(complex<double>));
  W[1] = polar(1., -2. * M_PI / N);
  W[0] = 1;
  for(int i = 2; i < N / 2; i++)
    W[i] = pow(W[1], i);
  int n = 1;
  int a = N / 2;
  for(int j = 0; j < log2(N); j++) {
    for(int i = 0; i < N; i++) {
      if(!(i & n)) {
        complex<double> temp = f[i];
        complex<double> Temp = W[(i * a) % (n * a)] * f[i + n];
        f[i] = temp + Temp;
        f[i + n] = temp - Temp;
      }
    }
    n *= 2;
    a = a / 2;
  }
}

void FFT(complex<double>* f, int N, double d)
{
  transform(f, N);
  for(int i = 0; i < N; i++)
    f[i] *= d; //multiplying by step
}

int main()
{
  float* timeVector = generateTimeVector (MAX, step);
  float* freqVector = generateFreqVector (MAX, step);
  
  complex<double> vec[MAX];
  for (i = 0; i < MAX; i++)
  {
      float t = timeVector[i];
      sineGenerate(vec, i, t, f1, a, 0);
  }
  
  FFT(vec, MAX, 1); //'d' should be 1 in order to have the same results of matlab fft(.)
  cout << "...printing the FFT of the array specified" << endl;
  float absFFT = 0.0;
  for(int j = 0; j < MAX; j++)
  {
     absFFT = 2*(std::abs(vec[j]))/MAX;
     pc.printf("%f, %f\n", freqVector[j], absFFT); //Y: absFFT, X: freqVector
  }
    
  return 0;
}
