
#ifndef KNOCK_API_0yx22l34755
#define KNOCK_API_0yx22l34755
#include <MMA8451Q.h>
#include "tsi_sensor.h"

typedef MMA8451Q Accelerometer;
typedef TSIAnalogSlider TouchSensor;

/******************************** Init and Finish ********************************/
void init();

void finish();

/******************************** Timing ********************************/


/** Get the time in milliseconds since the last marked time
  */
int getTime();

/** Set the marked time to the current time
  */
void markTime();

/** Do nothing for the specified time.
  * @param milliseconds, Number of milliseconds to do nothing.
  */
void sleep(float milliseconds);

/******************************** INPUTS AND OUTPUTS ********************************/

/** print a message
  * @param msg: the message to print
  * @param ...: variable arguments to enter into message
  */
void print(const char* msg, ...);

/** turn on/off red led
  * @param on: true to turn on, false to turn off
  */
void redLED(bool on);

/** turn on/off green led
  * @param on: true to turn on, false to turn off
  */
void greenLED(bool on);

/** turn on/off blue led
  * @param on: true to turn on, false to turn off
  */
void blueLED(bool on);

/** turn on/off blue led
  * @param red: amount of red , from 0 to 1
  * @param green: amount of red , from 0 to 1
  * @param blue: amount of red , from 0 to 1
  */
void setLED(float red, float green, float blue);

/** Turn on debugging. Prints each method call to the serial port.
  * @param _debug True to turn on debugging, false to turn it off.
  */
void setDebug(bool _debug);


/** Get the Accelerometer object
        Code for the accelerometer can be found in MMA8451Q.h
        important functions
        getAccX();
        getAccY();
        getAccZ();
  */
Accelerometer& getAccelerometer();

/** Get the Serial object to interface directly with the usb port
    Allows: getc, putc, printf, etc
    Examples: char c = #Serial.getc();
  */
Serial getSerialPort();

#endif