#include "KnockAPI.h"
#include "Includes/KnockBaseAPI.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

Timer timer;

void print(const char* msg, ...){
    char buffer[256];
    va_list args;
    va_start (args, msg);
    vsprintf (buffer,msg, args);
    va_end (args);
    port.printf(buffer);
}

/************************************************
 * timing functions
 ***********************************************/

int getTime(){
    int time = timer.read_ms();
    if(debug) print("getTime() = %d\r\n",time);
    return time;
}

void markTime(){
    if(debug) print("markTime()\r\n");
    timer.start();
}

void sleep(float milliseconds){
    if(debug) print("sleep(%f)\r\n",milliseconds);
    wait(milliseconds / 1000);
}

/******************************** INPUTS AND OUTPUTS ********************************/

void redLED(bool on){
    if(debug) print("blueLED(%d) \r\n", on);
    setLED(!on, 1, 1);
}

void greenLED(bool on){
    if(debug) print("blueLED(%d) \r\n", on);
    setLED(1, !on, 1);
}

void blueLED(bool on){
    if(debug) print("blueLED(%d) \r\n", on);
    setLED(1, 1, !on);
}

void setLED(float r, float g, float b){
    rl.write(r);
    gl.write(g);
    bl.write(b);
    if(debug) print("setLED(%f,%f,%f) \r\n", r,g,b);
}

void setDebug(bool _debug){
    if(debug) print("setDebug()= %d\r\n", _debug);
    debug = _debug;
}


Accelerometer& getAccelerometer(){
    return accelerometer;
}

Serial getSerialPort(){
    return port;
}


/************************************************
 * init/finish functions
 ***********************************************/


void init(){
    _initialize();
    markTime();
}

void finish(){
    _finish();
}
