#ifndef KNOCK_BASE_API_046o73i4277823
#define KNOCK_BASE_API_046o73i4277823

#include <stdarg.h>
#include <MMA8451Q.h>   // accelerometer
#include "tsi_sensor.h"

Serial port(USBTX,USBRX);

#define MMA8451_I2C_ADDRESS (0x1d<<1)

//http://mbed.org/users/wd5gnr/code/frdm_tsi_slider_led_blend/rev/ (tsi example)
MMA8451Q accelerometer(PTE25,PTE24, MMA8451_I2C_ADDRESS);

float turnOffset = 0.0;// the turn turnOffset
float crashSensitivity = 0.5; // crash sensitivity
float stopSensitivity = 0.2; // stop sensitivity
bool debug = false;

DigitalOut bl(LED1);
DigitalOut gl(LED2);
DigitalOut rl(LED3);

void utrace(const char* msg, ...){
    char buffer[256];
    va_list args;
    va_start (args, msg);
    vsprintf (buffer,msg, args);
    va_end (args);
    port.printf(buffer);
}

void flushSerialBuffer(void) { while (port.readable()) { port.getc(); } return; } 

void _initialize(){
    if(debug) utrace("initialize()\r\n");
    /// set leds
    rl.write(1);
    gl.write(1);
    bl.write(1);
    // Initialize Baud Rate for PC Console
//    pc.baud(38400);
}

void _finish(){
    if(debug) utrace("finish()\r\n");
}


#endif