#ifndef CNEURALNET_H
#define CNEURALNET_H

#include <vector>
#include <fstream>
#include <math.h>
#include "utils.h"

using namespace std;

// Neuron Struct
struct SNeuron
{
    int m_NumInputs; //the number of inputs into the neuron
    vector<float>  m_vecWeight; //the weights for each input
    SNeuron(int NumInputs); //ctor
};


// Neuron Layer Struct
struct SNeuronLayer
{
    int m_NumNeurons; //number of neurons in layer
    vector<SNeuron>     m_vecNeurons; //the layer of neurons
    SNeuronLayer(int NumNeurons, int NumInputsPerNeuron);
};


// Neural Net
class CNeuralNet
{   
private:   
    int m_NumInputs;
    int m_NumOutputs;
    int m_NumHiddenLayers;
    int m_NeuronsPerHiddenLyr;
    vector<SNeuronLayer> m_vecLayers;//storage for each neuron layer 

public:
    CNeuralNet();
    void CreateNet();
    vector<float> GetWeights()const; //weights from ANN
    int GetNumberOfWeights()const; //returns number of weights in net
    void PutWeights(vector<float> &weights); //replaces weights
    vector<float> Update(vector<float> &inputs); //gets outputs from net    
    inline float Sigmoid(float activation, float response); //sigmoid function
};

#endif