#ifndef CGENALG_H
#define CGENALG_H

#include <vector>
#include <algorithm>
#include <iostream>
#include <fstream>
#include "utils.h"

using namespace std;

// structure to hold genomes
struct SGenome
{
    vector <float> vecWeights;
    float dFitness;
    SGenome():dFitness(0){}
    SGenome( vector <float> w, float f): vecWeights(w), dFitness(f){}
    //overload '<' for sorting
    friend bool operator<(const SGenome& lhs, const SGenome& rhs)
    {
        return (lhs.dFitness < rhs.dFitness);
    }
};

// GA class
class CGenAlg
{
private:   
    vector <SGenome> m_vecPop;//vector of chromosome population
    int m_iPopSize;//population size
    int m_iChromoLength;//# weights per chromosome
    float m_dTotalFitness;//total fitness of population
    float m_dBestFitness;//best fitness
    float m_dWorstFitness;//worst fitness
    int m_iFittestGenome;//keeps track of the best genome
    float m_dMutationRate;//probability of mutation, 0.05-0.3 ideal
    float m_dCrossoverRate;//probability of chromosone cross-over, .7 ideal
    int   m_cGeneration;//generation counter

    void Crossover(const vector<float> &mum,
                    const vector<float> &dad,
                    vector<float> &baby1,
                    vector<float> &baby2);
    
    void Mutate(vector<float> &chromo);
    
    SGenome GetChromoRoulette();

    //introduce elitism
    void GrabNBest(int NBest, const int NumCopies, vector<SGenome> &vecPop);
    void CalculateBestWorstAvTot();
    void Reset();

public:       
    CGenAlg(int popsize, float MutRat, float CrossRat, int numweights);

    //runs GA for one generation.
    vector<SGenome> Epoch(vector<SGenome> &old_pop);

    //accessor functions
    vector<SGenome> GetChromos()const{return m_vecPop;}
    float AverageFitness()const{return m_dTotalFitness / m_iPopSize;}
    float BestFitness()const{return m_dBestFitness;}
};

#endif